
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Replace the text node child of the "p" element in barfoo with whitespace and normalize with validation.
 * isElementContentWhitespace should be false since the node is not in element content.  
* @author Curt Arnold
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-isElementContentWhitespace">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-isElementContentWhitespace</a>
*/
public final class textiselementcontentwhitespace04 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public textiselementcontentwhitespace04(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList pList;
      Element pElem;
      Text textNode;
      Text blankNode;
      Node returnedNode;
      boolean isElemContentWhitespace;
      DOMConfiguration domConfig;
      boolean canSetValidation;
      Node replacedNode;
      doc = (Document) load("barfoo", true);
      domConfig = doc.getDomConfig();
      canSetValidation = domConfig.canSetParameter("validate", Boolean.TRUE);
      
      if (canSetValidation) {
          domConfig.setParameter("validate", Boolean.TRUE);
      pList = doc.getElementsByTagName("p");
      pElem = (Element) pList.item(0);
      textNode = (Text) pElem.getFirstChild();
      blankNode = doc.createTextNode("   ");
      replacedNode = pElem.replaceChild(blankNode, textNode);
      doc.normalizeDocument();
      textNode = (Text) pElem.getFirstChild();
      isElemContentWhitespace = textNode.isElementContentWhitespace();
      assertFalse("notElemContent", isElemContentWhitespace);
}
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/textiselementcontentwhitespace04";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(textiselementcontentwhitespace04.class, args);
   }
}

