/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.csp.CSPHeaderConfiguration;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportCSPViolationMapper
extends AbstractMapper {
    private static final int MAX_LOG_SIZE = 4096;
    private static final Logger log = LoggerFactory.getLogger(ReportCSPViolationMapper.class);
    private final ContentSecurityPolicySettings settings;

    public ReportCSPViolationMapper(ContentSecurityPolicySettings settings) {
        this.settings = settings;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        if (this.requestMatches(request)) {
            return new IRequestHandler(){

                @Override
                public void respond(IRequestCycle requestCycle) {
                    try {
                        HttpServletRequest httpRequest = ((ServletWebRequest)requestCycle.getRequest()).getContainerRequest();
                        if (log.isErrorEnabled()) {
                            log.error(this.reportToString(httpRequest));
                        }
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException(e);
                    }
                }

                private String reportToString(HttpServletRequest httpRequest) throws IOException {
                    try (StringWriter sw = new StringWriter();){
                        char[] buffer = new char[4096];
                        int n = httpRequest.getReader().read(buffer);
                        if (-1 != n) {
                            sw.write(buffer, 0, n);
                        }
                        String string = sw.toString();
                        return string;
                    }
                }
            };
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return this.requestMatches(request) ? 1000 : 0;
    }

    private boolean requestMatches(Request request) {
        if (request instanceof ServletWebRequest) {
            if (!((ServletWebRequest)request).getContainerRequest().getMethod().equals("POST")) {
                return false;
            }
            for (CSPHeaderConfiguration curConfig : this.settings.getConfiguration().values()) {
                String mountPath = curConfig.getReportUriMountPath();
                if (mountPath == null || !this.urlStartsWith(request.getUrl(), this.getMountSegments(mountPath))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        return null;
    }
}

