/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.util.io.IClusterable;

public class ChoiceRenderer<T>
implements IChoiceRenderer<T>,
IClusterable {
    private static final long serialVersionUID = 1L;
    private final String displayExpression;
    private final String idExpression;

    public ChoiceRenderer() {
        this(null);
    }

    public ChoiceRenderer(String displayExpression) {
        this(displayExpression, null);
    }

    public ChoiceRenderer(String displayExpression, String idExpression) {
        this.displayExpression = displayExpression;
        this.idExpression = idExpression;
    }

    @Override
    public Object getDisplayValue(T object) {
        Object returnValue = object;
        if (this.displayExpression != null && object != null) {
            returnValue = PropertyResolver.getValue(this.displayExpression, object);
        }
        if (returnValue == null) {
            return "";
        }
        return returnValue;
    }

    @Override
    public String getIdValue(T object, int index) {
        if (this.idExpression == null) {
            return Integer.toString(index);
        }
        if (object == null) {
            return "";
        }
        Object returnValue = PropertyResolver.getValue(this.idExpression, object);
        if (returnValue == null) {
            return "";
        }
        return returnValue.toString();
    }
}

