/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.util.lang.Args;

public class DebugSettings {
    private boolean ajaxDebugModeEnabled = false;
    private boolean componentUseCheck = true;
    private boolean linePreciseReportingOnAddComponentEnabled = false;
    private boolean linePreciseReportingOnNewComponentEnabled = false;
    private ClassOutputStrategy outputMarkupContainerClassNameStrategy = ClassOutputStrategy.NONE;
    private String componentPathAttributeName = null;
    private boolean developmentUtilitiesEnabled = false;

    public boolean getComponentUseCheck() {
        return this.componentUseCheck;
    }

    public boolean isAjaxDebugModeEnabled() {
        return this.ajaxDebugModeEnabled;
    }

    public boolean isLinePreciseReportingOnAddComponentEnabled() {
        return this.linePreciseReportingOnAddComponentEnabled;
    }

    public boolean isLinePreciseReportingOnNewComponentEnabled() {
        return this.linePreciseReportingOnNewComponentEnabled;
    }

    @Deprecated(forRemoval=true)
    public boolean isOutputMarkupContainerClassName() {
        return this.outputMarkupContainerClassNameStrategy != ClassOutputStrategy.NONE;
    }

    public ClassOutputStrategy getOutputMarkupContainerClassNameStrategy() {
        return this.outputMarkupContainerClassNameStrategy;
    }

    public DebugSettings setAjaxDebugModeEnabled(boolean enable) {
        this.ajaxDebugModeEnabled = enable;
        return this;
    }

    public DebugSettings setComponentUseCheck(boolean componentUseCheck) {
        this.componentUseCheck = componentUseCheck;
        return this;
    }

    public DebugSettings setLinePreciseReportingOnAddComponentEnabled(boolean enable) {
        this.linePreciseReportingOnAddComponentEnabled = enable;
        return this;
    }

    public DebugSettings setLinePreciseReportingOnNewComponentEnabled(boolean enable) {
        this.linePreciseReportingOnNewComponentEnabled = enable;
        return this;
    }

    @Deprecated(forRemoval=true)
    public DebugSettings setOutputMarkupContainerClassName(boolean enable) {
        this.outputMarkupContainerClassNameStrategy = enable ? ClassOutputStrategy.HTML_COMMENT : ClassOutputStrategy.NONE;
        return this;
    }

    public DebugSettings setOutputMarkupContainerClassNameStrategy(ClassOutputStrategy strategy) {
        this.outputMarkupContainerClassNameStrategy = (ClassOutputStrategy)((Object)Args.notNull((Object)((Object)strategy), (String)"strategy"));
        return this;
    }

    public DebugSettings setOutputMarkupContainerClassNameStrategy(String strategyName) {
        ClassOutputStrategy strategy = Enum.valueOf(ClassOutputStrategy.class, strategyName);
        return this.setOutputMarkupContainerClassNameStrategy(strategy);
    }

    public DebugSettings setComponentPathAttributeName(String componentPathAttributeName) {
        this.componentPathAttributeName = componentPathAttributeName;
        return this;
    }

    public String getComponentPathAttributeName() {
        return this.componentPathAttributeName;
    }

    public DebugSettings setDevelopmentUtilitiesEnabled(boolean enable) {
        this.developmentUtilitiesEnabled = enable;
        return this;
    }

    public boolean isDevelopmentUtilitiesEnabled() {
        return this.developmentUtilitiesEnabled;
    }

    public static enum ClassOutputStrategy {
        HTML_COMMENT,
        TAG_ATTRIBUTE,
        NONE;

    }
}

