/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.action.MacroAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ConjunctRulesRuleElement;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RutaRule
extends AbstractRule {
    private ComposedRuleElement root;
    private Map<String, Object> labels;
    private Collection<String> ownLabels;

    public RutaRule(List<RuleElement> elements, RutaBlock parent, int id) {
        super(parent, id);
        this.root = new ComposedRuleElement(elements, null, null, null, null, parent);
        this.labels = new LinkedHashMap<String, Object>();
        this.ownLabels = new ArrayList<String>();
    }

    @Override
    public RuleApply apply(RutaStream stream, InferenceCrowd crowd) {
        return this.apply(stream, crowd, stream.isGreedyAnchoring());
    }

    public RuleApply apply(RutaStream stream, InferenceCrowd crowd, boolean remember) {
        RuleApply ruleApply = new RuleApply(this, remember);
        MatchContext context = new MatchContext(this.getParent());
        this.prepareEnvironment(context, stream);
        crowd.beginVisit(this, ruleApply);
        RuleMatch ruleMatch = new RuleMatch(this);
        this.root.startMatch(ruleMatch, ruleApply, null, null, stream, crowd);
        crowd.endVisit(this, ruleApply);
        this.cleanupEnvironment(context, stream);
        return ruleApply;
    }

    public String toString() {
        return this.root == null ? "<empty>" : this.root.toString();
    }

    public final List<RuleElement> getRuleElements() {
        return this.root.getRuleElements();
    }

    @Override
    public RutaEnvironment getEnvironment() {
        return this.getParent().getEnvironment();
    }

    public void setRuleElements(List<RuleElement> elements) {
        if (elements != null && elements.size() == 1 && elements.get(0) instanceof ConjunctRulesRuleElement) {
            this.root = (ComposedRuleElement)elements.get(0);
        } else {
            this.root.setRuleElements(elements);
        }
        if (elements != null) {
            for (RuleElement ruleElement : elements) {
                this.fillLabelMap(ruleElement, true);
            }
        }
    }

    private void fillLabelMap(RuleElement ruleElement, boolean own) {
        if (!StringUtils.isBlank((CharSequence)ruleElement.getLabel())) {
            this.labels.put(ruleElement.getLabel(), null);
            if (own) {
                this.ownLabels.add(ruleElement.getLabel());
            }
        }
        this.fillLabelMapWithActions(ruleElement.getActions(), own, new HashSet<AbstractRutaAction>());
        if (ruleElement instanceof ComposedRuleElement) {
            ComposedRuleElement cre = (ComposedRuleElement)ruleElement;
            List<RuleElement> ruleElements = cre.getRuleElements();
            for (RuleElement each : ruleElements) {
                this.fillLabelMap(each, own);
            }
        }
        this.fillLabelMapWithInlinedRules(ruleElement.getInlinedConditionRuleBlocks());
        this.fillLabelMapWithInlinedRules(ruleElement.getInlinedActionRuleBlocks());
    }

    private void fillLabelMapWithActions(List<AbstractRutaAction> actions, boolean own, Set<AbstractRutaAction> processedActions) {
        if (actions != null) {
            for (AbstractRutaAction action : actions) {
                if (processedActions.contains(action)) continue;
                processedActions.add(action);
                if (action != null && !StringUtils.isBlank((CharSequence)action.getLabel())) {
                    this.labels.put(action.getLabel(), null);
                    if (own) {
                        this.ownLabels.add(action.getLabel());
                    }
                }
                if (!(action instanceof MacroAction)) continue;
                MacroAction macroAction = (MacroAction)action;
                this.fillLabelMapWithActions(macroAction.getActions(), own, processedActions);
            }
        }
    }

    private void fillLabelMapWithInlinedRules(List<List<RutaStatement>> blocks) {
        if (blocks != null) {
            for (List<RutaStatement> list : blocks) {
                for (RutaStatement eachInlined : list) {
                    if (!(eachInlined instanceof RutaRule)) continue;
                    RutaRule inlinedRule = (RutaRule)eachInlined;
                    inlinedRule.setInlined(true);
                    this.fillLabelMap(inlinedRule.getRoot(), false);
                }
            }
        }
    }

    private void prepareEnvironment(MatchContext context, RutaStream stream) {
        if (this.isInlined()) {
            return;
        }
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        for (Map.Entry<String, Object> entry : this.labels.entrySet()) {
            String label = entry.getKey();
            if (environment.isVariable(label)) {
                Class variableType = environment.getVariableType(label);
                Class<AnnotationFS> variableGenericType = environment.getVariableGenericType(label);
                if (variableType != null && variableGenericType != null && variableType.isAssignableFrom(List.class) && variableGenericType.isAssignableFrom(AnnotationFS.class)) {
                    this.labels.put(label, environment.getVariableValue(label, stream));
                    continue;
                }
                if (variableType != null && variableType.isAssignableFrom(AnnotationFS.class)) continue;
                String type = variableType == null ? "unknown" : variableType.getSimpleName();
                throw new RuntimeException("Overriding global variable '" + label + "' of type '" + type + "' with a local label variable is not allowed (in script " + context.getParent().getName() + ")!");
            }
            environment.addVariable(label, "ANNOTATIONLIST");
        }
    }

    private void cleanupEnvironment(MatchContext context, RutaStream stream) {
        if (this.isInlined()) {
            return;
        }
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        for (Map.Entry<String, Object> entry : this.labels.entrySet()) {
            String label = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                environment.removeVariable(label);
                continue;
            }
            environment.setVariableValue(label, value);
        }
    }

    public ComposedRuleElement getRoot() {
        return this.root;
    }

    public Collection<String> getLabels() {
        return this.labels.keySet();
    }

    public Collection<String> getOwnLabels() {
        return this.ownLabels;
    }

    public void clearOwnLabels() {
        RutaEnvironment environment = this.getParent().getEnvironment();
        environment.clearTempVariables(this.ownLabels);
    }
}

