/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.JohnzonRecord;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.Meta;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;
import org.apache.johnzon.mapper.reflection.Records;

public abstract class BaseAccessMode
implements AccessMode {
    private static final Type[] NO_PARAMS = new Type[0];
    private FieldFilteringStrategy fieldFilteringStrategy = new SingleEntryFieldFilteringStrategy();
    private final boolean acceptHiddenConstructor;
    private final boolean useConstructor;

    protected BaseAccessMode(boolean useConstructor, boolean acceptHiddenConstructor) {
        this.useConstructor = useConstructor;
        this.acceptHiddenConstructor = acceptHiddenConstructor;
    }

    protected abstract Map<String, AccessMode.Reader> doFindReaders(Class<?> var1);

    protected abstract Map<String, AccessMode.Writer> doFindWriters(Class<?> var1);

    @Override
    public Comparator<String> fieldComparator(Class<?> clazz) {
        return null;
    }

    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindReaders(clazz));
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindWriters(clazz));
    }

    public void setFieldFilteringStrategy(FieldFilteringStrategy fieldFilteringStrategy) {
        this.fieldFilteringStrategy = fieldFilteringStrategy;
    }

    public FieldFilteringStrategy getFieldFilteringStrategy() {
        return this.fieldFilteringStrategy;
    }

    @Override
    public ObjectConverter.Reader<?> findReader(Class<?> clazz) {
        return null;
    }

    @Override
    public ObjectConverter.Writer<?> findWriter(Class<?> clazz) {
        return null;
    }

    @Override
    public Adapter<?, ?> findAdapter(Class<?> clazz) {
        return null;
    }

    @Override
    public void afterParsed(Class<?> clazz) {
    }

    @Override
    public AccessMode.Factory findFactory(final Class<?> clazz, Function<AnnotatedElement, String> ... parameterNameExtractors) {
        Constructor<?> cons;
        ObjectConverter.Codec[] objectConverters;
        Adapter[] constructorItemParameterConverters;
        Adapter[] constructorParameterConverters;
        String[] constructorParameters;
        Type[] factoryParameterTypes;
        boolean constructorHasArguments;
        Constructor<?> constructor = null;
        boolean record = Records.isRecord(clazz);
        if (record || Meta.getAnnotation(clazz, JohnzonRecord.class) != null) {
            constructor = this.findRecordConstructor(clazz);
        } else {
            for (Constructor<?> c : clazz.getDeclaredConstructors()) {
                if (c.getParameterTypes().length == 0) {
                    if (!Modifier.isPublic(c.getModifiers()) && this.acceptHiddenConstructor) {
                        c.setAccessible(true);
                    }
                    constructor = c;
                    if (this.useConstructor) continue;
                    break;
                }
                if (c.getAnnotation(ConstructorProperties.class) == null) continue;
                constructor = c;
                break;
            }
            if (constructor == null) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        }
        boolean bl = constructorHasArguments = constructor != null && constructor.getGenericParameterTypes().length > 0;
        if (constructorHasArguments) {
            factoryParameterTypes = constructor.getGenericParameterTypes();
            constructorParameters = new String[constructor.getGenericParameterTypes().length];
            Constructor<?> fc = constructor;
            String[] constructorProperties = Optional.ofNullable(constructor.getAnnotation(ConstructorProperties.class)).map(ConstructorProperties::value).orElseGet(() -> {
                if (record) {
                    return (String[])Stream.of(fc.getParameters()).map(p -> {
                        try {
                            if (parameterNameExtractors != null) {
                                return Stream.of(parameterNameExtractors).map(fn -> (String)fn.apply(p)).filter(Objects::nonNull).findFirst().orElseGet(p::getName);
                            }
                            JohnzonProperty property = Meta.getAnnotation(clazz.getMethod(p.getName(), new Class[0]), JohnzonProperty.class);
                            return property != null ? property.value() : p.getName();
                        }
                        catch (NoSuchMethodException e) {
                            return p.getName();
                        }
                    }).toArray(String[]::new);
                }
                return (String[])Stream.of(fc.getParameters()).map(p -> Optional.ofNullable(p.getAnnotation(JohnzonRecord.Name.class)).map(JohnzonRecord.Name::value).orElseGet(p::getName)).toArray(String[]::new);
            });
            System.arraycopy(constructorProperties, 0, constructorParameters, 0, constructorParameters.length);
            constructorParameterConverters = new Adapter[constructor.getGenericParameterTypes().length];
            constructorItemParameterConverters = new Adapter[constructorParameterConverters.length];
            objectConverters = new ObjectConverter.Codec[constructorParameterConverters.length];
            for (int i = 0; i < constructorParameters.length; ++i) {
                for (Annotation a : constructor.getParameterAnnotations()[i]) {
                    if (a.annotationType() != JohnzonConverter.class) continue;
                    try {
                        MapperConverter mapperConverter = ((JohnzonConverter)JohnzonConverter.class.cast(a)).value().newInstance();
                        if (mapperConverter instanceof Converter) {
                            ConverterAdapter converter = new ConverterAdapter((Converter)mapperConverter, constructor.getGenericParameterTypes()[i]);
                            if (Converters.matches(constructor.getParameterTypes()[i], converter)) {
                                constructorParameterConverters[i] = converter;
                                constructorItemParameterConverters[i] = null;
                                continue;
                            }
                            constructorParameterConverters[i] = null;
                            constructorItemParameterConverters[i] = converter;
                            continue;
                        }
                        objectConverters[i] = (ObjectConverter.Codec)mapperConverter;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        } else {
            factoryParameterTypes = NO_PARAMS;
            constructorParameters = null;
            constructorParameterConverters = null;
            constructorItemParameterConverters = null;
            objectConverters = null;
        }
        if ((cons = constructor) != null && !cons.isAccessible()) {
            cons.setAccessible(true);
        }
        return new AccessMode.Factory(){

            @Override
            public Object create(Object[] params) {
                if (cons == null) {
                    throw new IllegalArgumentException(clazz.getName() + " can't be instantiated by Johnzon, this is a write only class");
                }
                try {
                    return params == null ? cons.newInstance(new Object[0]) : cons.newInstance(params);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            @Override
            public Type[] getParameterTypes() {
                return factoryParameterTypes;
            }

            @Override
            public String[] getParameterNames() {
                return constructorParameters;
            }

            @Override
            public Adapter<?, ?>[] getParameterConverter() {
                return constructorParameterConverters;
            }

            @Override
            public Adapter<?, ?>[] getParameterItemConverter() {
                return constructorItemParameterConverters;
            }

            @Override
            public ObjectConverter.Codec<?>[] getObjectConverter() {
                return objectConverters;
            }
        };
    }

    private Constructor<?> findRecordConstructor(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredConstructors()).max(Comparator.comparing(Constructor::getParameterCount)).map(c -> {
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            return c;
        }).orElse(null);
    }

    @Override
    public Method findAnyGetter(Class<?> clazz) {
        Method m = null;
        for (Method current : clazz.getMethods()) {
            if (current.getAnnotation(JohnzonAny.class) == null || current.getParameterTypes().length != 0) continue;
            if (!Map.class.isAssignableFrom(current.getReturnType())) {
                throw new IllegalArgumentException("@JohnzonAny getters can only return a Map<String, Object>");
            }
            if (m != null) {
                throw new IllegalArgumentException("Ambiguous @JohnzonAny on " + String.valueOf(m) + " and " + String.valueOf(current));
            }
            m = current;
        }
        return m;
    }

    @Override
    public Method findAnySetter(Class<?> clazz) {
        Method m = null;
        for (Method current : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (current.getAnnotation(JohnzonAny.class) == null || (parameterTypes = current.getParameterTypes()).length != 2 || parameterTypes[0] != String.class) continue;
            if (m != null) {
                throw new IllegalArgumentException("Ambiguous @JohnzonAny on " + String.valueOf(m) + " and " + String.valueOf(current));
            }
            m = current;
        }
        return m;
    }

    @Override
    public Field findAnyField(Class<?> clazz) {
        if (clazz.isInterface() || clazz.isEnum()) {
            return null;
        }
        Class<?> current = clazz;
        HashSet visited = new HashSet();
        while (current != null && current != Object.class && visited.add(current)) {
            for (Field f : current.getDeclaredFields()) {
                if (!f.isAnnotationPresent(JohnzonAny.class)) continue;
                return f;
            }
            current = clazz.getSuperclass();
        }
        return null;
    }

    private <T> Map<String, T> sanitize(Class<?> type, Map<String, T> delegate) {
        for (String field : this.fieldFilteringStrategy.select(type)) {
            delegate.remove(field);
        }
        return delegate;
    }

    public static class SingleEntryFieldFilteringStrategy
    extends ConfiguredFieldFilteringStrategy {
        @Override
        public Collection<String> select(Class<?> type) {
            for (Map.Entry<Class<?>, Collection<String>> entry : this.getFieldsToRemove().entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                return entry.getValue();
            }
            return Collections.emptySet();
        }
    }

    public static interface FieldFilteringStrategy {
        public Collection<String> select(Class<?> var1);
    }

    public static class AllEntriesFieldFilteringStrategy
    extends ConfiguredFieldFilteringStrategy {
        @Override
        public Collection<String> select(Class<?> type) {
            return this.getFieldsToRemove().entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(type)).flatMap(entry -> ((Collection)entry.getValue()).stream()).collect(Collectors.toSet());
        }
    }

    public static abstract class ConfiguredFieldFilteringStrategy
    implements FieldFilteringStrategy {
        private final Map<Class<?>, Collection<String>> fieldsToRemove = new LinkedHashMap();

        public ConfiguredFieldFilteringStrategy() {
            this.fieldsToRemove.put(Throwable.class, Arrays.asList("suppressedExceptions", "cause"));
        }

        public Map<Class<?>, Collection<String>> getFieldsToRemove() {
            return this.fieldsToRemove;
        }
    }
}

