/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.extensions.management.connect.adapter.model;

import org.apache.streampipes.extensions.api.connect.IEventCollector;
import org.apache.streampipes.extensions.api.connect.context.IAdapterRuntimeContext;
import org.apache.streampipes.extensions.management.connect.adapter.AdapterPipelineGenerator;
import org.apache.streampipes.extensions.management.connect.adapter.model.pipeline.AdapterPipeline;
import org.apache.streampipes.model.connect.adapter.AdapterDescription;

import java.util.Map;

public class EventCollector implements IEventCollector {

  private final AdapterPipeline adapterPipeline;
  private final IAdapterRuntimeContext runtimeContext;

  public EventCollector(AdapterPipeline adapterPipeline,
                        IAdapterRuntimeContext runtimeContext) {
    this.adapterPipeline = adapterPipeline;
    this.runtimeContext = runtimeContext;
  }

  public static IEventCollector from(AdapterDescription adapterDescription,
                                     IAdapterRuntimeContext runtimeContext) {
    var adapterPipeline = new AdapterPipelineGenerator().generatePipeline(adapterDescription);
    return new EventCollector(adapterPipeline, runtimeContext);
  }

  @Override
  public void collect(Map<String, Object> event) {
    try {
      adapterPipeline.process(event);
    } catch (RuntimeException e) {
      runtimeContext.getLogger().error(e);
    }
  }
}
