/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerBuilder;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerCustomizer;
import org.springframework.boot.task.TaskSchedulerBuilder;
import org.springframework.boot.task.TaskSchedulerCustomizer;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.boot.task.ThreadPoolTaskSchedulerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

class TaskSchedulingConfigurations {
    TaskSchedulingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class SimpleAsyncTaskSchedulerBuilderConfiguration {
        private final TaskSchedulingProperties properties;
        private final ObjectProvider<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers;

        SimpleAsyncTaskSchedulerBuilderConfiguration(TaskSchedulingProperties properties, ObjectProvider<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers) {
            this.properties = properties;
            this.taskSchedulerCustomizers = taskSchedulerCustomizers;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        SimpleAsyncTaskSchedulerBuilder simpleAsyncTaskSchedulerBuilder() {
            return this.builder();
        }

        @Bean(name={"simpleAsyncTaskSchedulerBuilder"})
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskSchedulerBuilder simpleAsyncTaskSchedulerBuilderVirtualThreads() {
            SimpleAsyncTaskSchedulerBuilder builder = this.builder();
            builder = builder.virtualThreads(Boolean.valueOf(true));
            return builder;
        }

        private SimpleAsyncTaskSchedulerBuilder builder() {
            SimpleAsyncTaskSchedulerBuilder builder = new SimpleAsyncTaskSchedulerBuilder();
            builder = builder.threadNamePrefix(this.properties.getThreadNamePrefix());
            builder = builder.customizers(this.taskSchedulerCustomizers.orderedStream()::iterator);
            TaskSchedulingProperties.Simple simple = this.properties.getSimple();
            builder = builder.concurrencyLimit(simple.getConcurrencyLimit());
            TaskSchedulingProperties.Shutdown shutdown = this.properties.getShutdown();
            if (shutdown.isAwaitTermination()) {
                builder = builder.taskTerminationTimeout(shutdown.getAwaitTerminationPeriod());
            }
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ThreadPoolTaskSchedulerBuilderConfiguration {
        ThreadPoolTaskSchedulerBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TaskSchedulerBuilder.class, ThreadPoolTaskSchedulerBuilder.class})
        ThreadPoolTaskSchedulerBuilder threadPoolTaskSchedulerBuilder(TaskSchedulingProperties properties, ObjectProvider<ThreadPoolTaskSchedulerCustomizer> threadPoolTaskSchedulerCustomizers, ObjectProvider<TaskSchedulerCustomizer> taskSchedulerCustomizers) {
            TaskSchedulingProperties.Shutdown shutdown = properties.getShutdown();
            ThreadPoolTaskSchedulerBuilder builder = new ThreadPoolTaskSchedulerBuilder();
            builder = builder.poolSize(properties.getPool().getSize());
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(threadPoolTaskSchedulerCustomizers);
            builder = builder.additionalCustomizers(taskSchedulerCustomizers.orderedStream().map(this::adapt).toList());
            return builder;
        }

        private ThreadPoolTaskSchedulerCustomizer adapt(TaskSchedulerCustomizer customizer) {
            return arg_0 -> ((TaskSchedulerCustomizer)customizer).customize(arg_0);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class TaskSchedulerBuilderConfiguration {
        TaskSchedulerBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        TaskSchedulerBuilder taskSchedulerBuilder(TaskSchedulingProperties properties, ObjectProvider<TaskSchedulerCustomizer> taskSchedulerCustomizers) {
            TaskSchedulerBuilder builder = new TaskSchedulerBuilder();
            builder = builder.poolSize(properties.getPool().getSize());
            TaskSchedulingProperties.Shutdown shutdown = properties.getShutdown();
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(taskSchedulerCustomizers);
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.context.annotation.internalScheduledAnnotationProcessor"})
    @ConditionalOnMissingBean(value={TaskScheduler.class, ScheduledExecutorService.class})
    static class TaskSchedulerConfiguration {
        TaskSchedulerConfiguration() {
        }

        @Bean(name={"taskScheduler"})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskScheduler taskSchedulerVirtualThreads(SimpleAsyncTaskSchedulerBuilder builder) {
            return builder.build();
        }

        @Bean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskScheduler taskScheduler(TaskSchedulerBuilder taskSchedulerBuilder, ObjectProvider<ThreadPoolTaskSchedulerBuilder> threadPoolTaskSchedulerBuilderProvider) {
            ThreadPoolTaskSchedulerBuilder threadPoolTaskSchedulerBuilder = (ThreadPoolTaskSchedulerBuilder)threadPoolTaskSchedulerBuilderProvider.getIfUnique();
            if (threadPoolTaskSchedulerBuilder != null) {
                return threadPoolTaskSchedulerBuilder.build();
            }
            return taskSchedulerBuilder.build();
        }
    }
}

