/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl.sasl;

import java.util.Arrays;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.EngineSaslDriver;
import org.apache.qpid.protonj2.engine.impl.ProtonAttachments;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.sasl.ProtonSaslHandler;
import org.apache.qpid.protonj2.engine.sasl.SaslContext;
import org.apache.qpid.protonj2.engine.sasl.SaslOutcome;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.security.SaslPerformative;
import org.apache.qpid.protonj2.types.transport.AMQPHeader;

abstract class ProtonSaslContext
implements SaslContext {
    protected final ProtonSaslHandler saslHandler;
    private ProtonAttachments attachments;
    private Object linkedResource;
    protected Symbol[] serverMechanisms;
    protected Symbol chosenMechanism;
    protected String hostname;
    protected EngineSaslDriver.SaslState state = EngineSaslDriver.SaslState.IDLE;
    protected SaslOutcome outcome;
    private boolean done;

    ProtonSaslContext(ProtonSaslHandler handler) {
        this.saslHandler = handler;
    }

    @Override
    public ProtonAttachments getAttachments() {
        return this.attachments == null ? (this.attachments = new ProtonAttachments()) : this.attachments;
    }

    @Override
    public ProtonSaslContext setLinkedResource(Object resource) {
        this.linkedResource = resource;
        return this;
    }

    @Override
    public <T> T getLinkedResource() {
        return (T)this.linkedResource;
    }

    @Override
    public <T> T getLinkedResource(Class<T> typeClass) {
        return typeClass.cast(this.linkedResource);
    }

    @Override
    public abstract SaslContext.Role getRole();

    @Override
    public boolean isServer() {
        return this.getRole() == SaslContext.Role.SERVER;
    }

    @Override
    public boolean isClient() {
        return this.getRole() == SaslContext.Role.CLIENT;
    }

    @Override
    public SaslOutcome getSaslOutcome() {
        return this.outcome;
    }

    @Override
    public EngineSaslDriver.SaslState getSaslState() {
        return this.state;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    ProtonSaslContext done(SaslOutcome outcome) {
        this.done = true;
        this.outcome = outcome;
        this.state = outcome == SaslOutcome.SASL_OK ? EngineSaslDriver.SaslState.AUTHENTICATED : EngineSaslDriver.SaslState.AUTHENTICATION_FAILED;
        return this;
    }

    @Override
    public Symbol getChosenMechanism() {
        return this.chosenMechanism;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Symbol[] getServerMechanisms() {
        return this.serverMechanisms != null ? Arrays.copyOf(this.serverMechanisms, this.serverMechanisms.length) : null;
    }

    ProtonSaslHandler getHandler() {
        return this.saslHandler;
    }

    abstract ProtonSaslContext handleContextInitialization(ProtonEngine var1);

    abstract AMQPHeader.HeaderHandler<EngineHandlerContext> headerReadContext();

    abstract AMQPHeader.HeaderHandler<EngineHandlerContext> headerWriteContext();

    abstract SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslReadContext();

    abstract SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslWriteContext();
}

