/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow.git;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class Flow {
    private final String flowId;
    private final Map<Integer, FlowPointer> versions = new HashMap<Integer, FlowPointer>();

    public Flow(String flowId) {
        this.flowId = flowId;
    }

    public boolean hasVersion(int version) {
        return this.versions.containsKey(version);
    }

    public FlowPointer getFlowVersion(int version) {
        return this.versions.get(version);
    }

    public void putVersion(int version, FlowPointer pointer) {
        this.versions.put(version, pointer);
    }

    Map<Integer, FlowPointer> getVersions() {
        return this.versions;
    }

    Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Optional<Integer> latestVerOpt = this.getLatestVersion();
        if (!latestVerOpt.isPresent()) {
            throw new IllegalStateException("Flow version is not added yet, can not be serialized.");
        }
        Integer latestVer = latestVerOpt.get();
        FlowPointer latestFlowPointer = this.versions.get(latestVer);
        map.put("ver", latestVer);
        map.put("file", latestFlowPointer.fileName);
        if (latestFlowPointer.flowName != null) {
            map.put("flowName", latestFlowPointer.flowName);
        }
        if (latestFlowPointer.flowDescription != null) {
            map.put("flowDesc", latestFlowPointer.flowDescription);
        }
        if (latestFlowPointer.author != null) {
            map.put("author", latestFlowPointer.author);
        }
        if (latestFlowPointer.comment != null) {
            map.put("comments", latestFlowPointer.comment);
        }
        if (latestFlowPointer.created != null) {
            map.put("created", latestFlowPointer.created);
        }
        return map;
    }

    Optional<Integer> getLatestVersion() {
        return this.versions.keySet().stream().reduce(Integer::max);
    }

    public static class FlowPointer {
        private String gitRev;
        private String objectId;
        private final String fileName;
        private String flowName;
        private String flowDescription;
        private String author;
        private String comment;
        private Long created;

        public FlowPointer(String fileName) {
            this.fileName = fileName;
        }

        public void setGitRev(String gitRev) {
            this.gitRev = gitRev;
        }

        public String getGitRev() {
            return this.gitRev;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public String getFlowName() {
            return this.flowName;
        }

        public void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        public String getFlowDescription() {
            return this.flowDescription;
        }

        public void setFlowDescription(String flowDescription) {
            this.flowDescription = flowDescription;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Long getCreated() {
            return this.created;
        }

        public void setCreated(Long created) {
            this.created = created;
        }
    }
}

