/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.util;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;

public class UserGroupUtil {
    public static Set<String> getUserGroups(Authorizer authorizer, String userIdentity) {
        if (authorizer instanceof ManagedAuthorizer) {
            ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
            UserGroupProvider userGroupProvider = managedAuthorizer.getAccessPolicyProvider().getUserGroupProvider();
            UserAndGroups userAndGroups = userGroupProvider.getUserAndGroups(userIdentity);
            Set userGroups = userAndGroups.getGroups();
            if (userGroups == null || userGroups.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            return userAndGroups.getGroups().stream().map(group -> group.getName()).collect(Collectors.toSet());
        }
        return null;
    }
}

