/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManagerHolder;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.x11.X11ForwardSupport;

public interface ConnectionService
extends Service,
SessionHeartbeatController,
UnknownChannelReferenceHandlerManager,
PortForwardingEventListenerManager,
PortForwardingEventListenerManagerHolder {
    public long registerChannel(Channel var1) throws IOException;

    public void unregisterChannel(Channel var1);

    public Forwarder getForwarder();

    default public Buffer request(String request, Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive timeout requested: %d", timeout);
        return this.request(request, buffer, TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    default public Buffer request(String request, Buffer buffer, Duration timeout) throws IOException {
        Objects.requireNonNull(timeout, "No timeout specified");
        return this.request(request, buffer, timeout.toMillis());
    }

    public Buffer request(String var1, Buffer var2, long var3) throws IOException;

    public GlobalRequestFuture request(Buffer var1, String var2, GlobalRequestFuture.ReplyHandler var3) throws IOException;

    public AgentForwardSupport getAgentForwardSupport();

    public X11ForwardSupport getX11ForwardSupport();

    public boolean isAllowMoreSessions();

    public void setAllowMoreSessions(boolean var1);
}

