/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connector.impl;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class MBeanHandler {
    private static final Logger LOG = Logger.getLogger(MBeanHandler.class.getName());

    private MBeanHandler() {
    }

    public static void registerMBean(Object mbean, String objectNameString) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(objectNameString);
            if (!mBeanServer.isRegistered(objectName)) {
                mBeanServer.registerMBean(mbean, objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            LOG.log(Level.SEVERE, "Unexpected exception while register mbean", ex);
        }
    }

    public static void unregisterMBean(String objectNameString) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(objectNameString);
            if (mBeanServer.isRegistered(objectName)) {
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException ex) {
            LOG.log(Level.SEVERE, "Unexpected exception while register mbean", ex);
        }
    }
}

