/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command.completers;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.api.action.lifecycle.Destroy;
import org.apache.karaf.shell.api.action.lifecycle.Init;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

@Service
public class ConfigurationCompleter
implements Completer,
ConfigurationListener {
    private final StringsCompleter delegate = new StringsCompleter();
    @Reference
    private ConfigurationAdmin admin;
    @Reference
    private BundleContext bundleContext;
    private ServiceRegistration<ConfigurationListener> registration;

    public void setAdmin(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    @Init
    public void init() {
        Configuration[] configs;
        this.registration = this.bundleContext.registerService(ConfigurationListener.class, (Object)this, null);
        try {
            configs = this.admin.listConfigurations(null);
            if (configs == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        ArrayList<String> pids = new ArrayList<String>();
        for (Configuration config : configs) {
            pids.add(config.getPid());
        }
        this.delegate.getStrings().addAll(pids);
    }

    @Destroy
    public void destroy() {
        this.registration.unregister();
    }

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        return this.delegate.complete(session, commandLine, candidates);
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        String pid = configurationEvent.getPid();
        if (configurationEvent.getType() == 2) {
            this.delegate.getStrings().remove(pid);
        } else if (configurationEvent.getType() == 1) {
            this.delegate.getStrings().add(pid);
        }
    }
}

