/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.CompositeReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public final class QueryableStoreTypes {
    public static <K, V> QueryableStoreType<ReadOnlyKeyValueStore<K, V>> keyValueStore() {
        return new KeyValueStoreType();
    }

    public static <K, V> QueryableStoreType<ReadOnlyKeyValueStore<K, ValueAndTimestamp<V>>> timestampedKeyValueStore() {
        return new TimestampedKeyValueStoreType();
    }

    public static <K, V> QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStore() {
        return new WindowStoreType();
    }

    public static <K, V> QueryableStoreType<ReadOnlyWindowStore<K, ValueAndTimestamp<V>>> timestampedWindowStore() {
        return new TimestampedWindowStoreType();
    }

    public static <K, V> QueryableStoreType<ReadOnlySessionStore<K, V>> sessionStore() {
        return new SessionStoreType();
    }

    public static class KeyValueStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyKeyValueStore<K, V>> {
        KeyValueStoreType() {
            super(Collections.singleton(ReadOnlyKeyValueStore.class));
        }

        @Override
        public ReadOnlyKeyValueStore<K, V> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyKeyValueStore(storeProvider, this, storeName);
        }
    }

    private static class TimestampedKeyValueStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyKeyValueStore<K, ValueAndTimestamp<V>>> {
        TimestampedKeyValueStoreType() {
            super(Set.of(TimestampedKeyValueStore.class, ReadOnlyKeyValueStore.class));
        }

        @Override
        public ReadOnlyKeyValueStore<K, ValueAndTimestamp<V>> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyKeyValueStore(storeProvider, this, storeName);
        }
    }

    public static class WindowStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyWindowStore<K, V>> {
        WindowStoreType() {
            super(Collections.singleton(ReadOnlyWindowStore.class));
        }

        @Override
        public ReadOnlyWindowStore<K, V> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyWindowStore(storeProvider, this, storeName);
        }
    }

    private static class TimestampedWindowStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyWindowStore<K, ValueAndTimestamp<V>>> {
        TimestampedWindowStoreType() {
            super(Set.of(TimestampedWindowStore.class, ReadOnlyWindowStore.class));
        }

        @Override
        public ReadOnlyWindowStore<K, ValueAndTimestamp<V>> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyWindowStore(storeProvider, this, storeName);
        }
    }

    public static class SessionStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlySessionStore<K, V>> {
        SessionStoreType() {
            super(Collections.singleton(ReadOnlySessionStore.class));
        }

        @Override
        public ReadOnlySessionStore<K, V> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlySessionStore(storeProvider, this, storeName);
        }
    }

    private static abstract class QueryableStoreTypeMatcher<T>
    implements QueryableStoreType<T> {
        private final Set<Class<?>> matchTo;

        QueryableStoreTypeMatcher(Set<Class<?>> matchTo) {
            this.matchTo = matchTo;
        }

        @Override
        public boolean accepts(StateStore stateStore) {
            for (Class<?> matchToClass : this.matchTo) {
                if (matchToClass.isAssignableFrom(stateStore.getClass())) continue;
                return false;
            }
            return true;
        }
    }
}

