/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.internals.AcknowledgementBatch;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.ShareFetchConfig;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ShareSessionHandler {
    private final Logger log;
    private final int node;
    private final Uuid memberId;
    private ShareRequestMetadata nextMetadata;
    private final LinkedHashMap<TopicPartition, TopicIdPartition> sessionPartitions;
    private LinkedHashMap<TopicPartition, TopicIdPartition> nextPartitions;
    private LinkedHashMap<TopicIdPartition, Acknowledgements> nextAcknowledgements;

    public ShareSessionHandler(LogContext logContext, int node, Uuid memberId) {
        this.log = logContext.logger(ShareSessionHandler.class);
        this.node = node;
        this.memberId = memberId;
        this.nextMetadata = ShareRequestMetadata.initialEpoch(memberId);
        this.sessionPartitions = new LinkedHashMap();
        this.nextPartitions = new LinkedHashMap();
        this.nextAcknowledgements = new LinkedHashMap();
    }

    Map<TopicPartition, TopicIdPartition> sessionPartitionMap() {
        return this.sessionPartitions;
    }

    public Collection<TopicIdPartition> sessionPartitions() {
        return Collections.unmodifiableCollection(this.sessionPartitions.values());
    }

    public void addPartitionToFetch(TopicIdPartition topicIdPartition, Acknowledgements partitionAcknowledgements) {
        this.nextPartitions.put(topicIdPartition.topicPartition(), topicIdPartition);
        if (partitionAcknowledgements != null) {
            this.nextAcknowledgements.put(topicIdPartition, partitionAcknowledgements);
        }
    }

    public void addPartitionToAcknowledgeOnly(TopicIdPartition topicIdPartition, Acknowledgements partitionAcknowledgements) {
        this.nextAcknowledgements.put(topicIdPartition, partitionAcknowledgements);
    }

    public boolean isNewSession() {
        return this.nextMetadata.isNewSession();
    }

    public ShareFetchRequest.Builder newShareFetchBuilder(String groupId, ShareFetchConfig shareFetchConfig, boolean canSkipIfRequestEmpty) {
        ArrayList<TopicIdPartition> added = new ArrayList<TopicIdPartition>();
        ArrayList<TopicIdPartition> removed = new ArrayList<TopicIdPartition>();
        ArrayList<TopicIdPartition> replaced = new ArrayList<TopicIdPartition>();
        if (this.nextMetadata.isNewSession()) {
            for (Map.Entry<TopicPartition, TopicIdPartition> entry : this.nextPartitions.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                TopicIdPartition topicIdPartition = entry.getValue();
                this.sessionPartitions.put(topicPartition, topicIdPartition);
            }
            added.addAll(this.sessionPartitions.values());
        } else {
            Iterator<Map.Entry<TopicPartition, TopicIdPartition>> partitionIterator = this.sessionPartitions.entrySet().iterator();
            while (partitionIterator.hasNext()) {
                Map.Entry<TopicPartition, TopicIdPartition> entry = partitionIterator.next();
                TopicPartition topicPartition = entry.getKey();
                TopicIdPartition prevData = entry.getValue();
                TopicIdPartition nextData = (TopicIdPartition)this.nextPartitions.remove(topicPartition);
                if (nextData != null) {
                    if (prevData.equals(nextData)) continue;
                    this.nextPartitions.put(topicPartition, nextData);
                    entry.setValue(nextData);
                    replaced.add(prevData);
                    continue;
                }
                partitionIterator.remove();
                removed.add(prevData);
            }
            for (Map.Entry<TopicPartition, TopicIdPartition> entry : this.nextPartitions.entrySet()) {
                TopicPartition topicPartition2 = entry.getKey();
                TopicIdPartition topicIdPartition = entry.getValue();
                this.sessionPartitions.put(topicPartition2, topicIdPartition);
                added.add(topicIdPartition);
            }
        }
        removed.addAll(replaced);
        boolean hasRenewAcknowledgements = false;
        HashMap<TopicIdPartition, List<ShareFetchRequestData.AcknowledgementBatch>> hashMap = new HashMap<TopicIdPartition, List<ShareFetchRequestData.AcknowledgementBatch>>();
        if (!this.nextAcknowledgements.isEmpty()) {
            for (Map.Entry<TopicIdPartition, Acknowledgements> partitionsAcks : this.nextAcknowledgements.entrySet()) {
                List<AcknowledgementBatch> partitionAckBatches = partitionsAcks.getValue().getAcknowledgementBatches();
                for (AcknowledgementBatch ackBatch : partitionAckBatches) {
                    if (ackBatch.acknowledgeTypes().contains(AcknowledgeType.RENEW.id)) {
                        hasRenewAcknowledgements = true;
                    }
                    hashMap.computeIfAbsent(partitionsAcks.getKey(), k -> new ArrayList()).add(ackBatch.toShareFetchRequest());
                }
            }
        }
        this.nextPartitions = new LinkedHashMap();
        this.nextAcknowledgements = new LinkedHashMap();
        if (canSkipIfRequestEmpty && added.isEmpty() && removed.isEmpty() && hashMap.isEmpty()) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Build ShareFetch {} for node {}. Added {}, removed {}, replaced {} out of {}", new Object[]{this.nextMetadata, this.node, this.topicIdPartitionsToLogString(added), this.topicIdPartitionsToLogString(removed), this.topicIdPartitionsToLogString(replaced), this.topicIdPartitionsToLogString(this.sessionPartitions.values())});
        }
        if (hasRenewAcknowledgements) {
            return ShareFetchRequest.Builder.forConsumer(groupId, this.nextMetadata, 0, 0, 0, 0, 0, shareFetchConfig.shareAcquireMode.id, true, added, removed, hashMap);
        }
        if (canSkipIfRequestEmpty) {
            return ShareFetchRequest.Builder.forConsumer(groupId, this.nextMetadata, 0, 0, 0, 0, 0, shareFetchConfig.shareAcquireMode.id, false, added, removed, hashMap);
        }
        return ShareFetchRequest.Builder.forConsumer(groupId, this.nextMetadata, shareFetchConfig.maxWaitMs, shareFetchConfig.minBytes, shareFetchConfig.maxBytes, shareFetchConfig.maxPollRecords, shareFetchConfig.maxPollRecords, shareFetchConfig.shareAcquireMode.id, false, added, removed, hashMap);
    }

    public ShareAcknowledgeRequest.Builder newShareAcknowledgeBuilder(String groupId, ShareFetchConfig shareFetchConfig) {
        if (this.nextMetadata.isNewSession()) {
            this.nextPartitions.clear();
            this.nextAcknowledgements.clear();
            return null;
        }
        boolean hasRenewAcknowledgements = false;
        HashMap<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgementBatches = new HashMap<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>>();
        if (!this.nextAcknowledgements.isEmpty()) {
            for (Map.Entry<TopicIdPartition, Acknowledgements> partitionsAcks : this.nextAcknowledgements.entrySet()) {
                List<AcknowledgementBatch> partitionAckBatches = partitionsAcks.getValue().getAcknowledgementBatches();
                for (AcknowledgementBatch ackBatch : partitionAckBatches) {
                    if (ackBatch.acknowledgeTypes().contains(AcknowledgeType.RENEW.id)) {
                        hasRenewAcknowledgements = true;
                    }
                    acknowledgementBatches.computeIfAbsent(partitionsAcks.getKey(), k -> new ArrayList()).add(ackBatch.toShareAcknowledgeRequest());
                }
            }
        }
        this.nextAcknowledgements = new LinkedHashMap();
        return ShareAcknowledgeRequest.Builder.forConsumer(groupId, this.nextMetadata, hasRenewAcknowledgements, acknowledgementBatches);
    }

    private String topicIdPartitionsToLogString(Collection<TopicIdPartition> partitions) {
        if (!this.log.isTraceEnabled()) {
            return String.format("%d partition(s)", partitions.size());
        }
        return "(" + partitions.stream().map(TopicIdPartition::toString).collect(Collectors.joining(", ")) + ")";
    }

    public boolean handleResponse(ShareFetchResponse response, short version) {
        if (response.error() == Errors.SHARE_SESSION_NOT_FOUND || response.error() == Errors.INVALID_SHARE_SESSION_EPOCH || response.error() == Errors.SHARE_SESSION_LIMIT_REACHED) {
            this.log.info("Node {} was unable to process the ShareFetch request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = this.nextMetadata.nextCloseExistingAttemptNew();
            return false;
        }
        if (response.error() != Errors.NONE) {
            this.log.info("Node {} was unable to process the ShareFetch request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = this.nextMetadata.nextEpoch();
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node {} sent a ShareFetch response with throttleTimeMs = {} for session {}", new Object[]{this.node, response.throttleTimeMs(), this.memberId});
        }
        this.nextMetadata = this.nextMetadata.nextEpoch();
        return true;
    }

    public boolean handleResponse(ShareAcknowledgeResponse response, short version) {
        if (response.error() == Errors.SHARE_SESSION_NOT_FOUND || response.error() == Errors.INVALID_SHARE_SESSION_EPOCH) {
            this.log.info("Node {} was unable to process the ShareAcknowledge request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = this.nextMetadata.nextCloseExistingAttemptNew();
            return false;
        }
        if (response.error() != Errors.NONE) {
            this.log.info("Node {} was unable to process the ShareAcknowledge request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = this.nextMetadata.nextEpoch();
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node {} sent a ShareAcknowledge response with throttleTimeMs = {} for session {}", new Object[]{this.node, response.throttleTimeMs(), this.memberId});
        }
        this.nextMetadata = this.nextMetadata.nextEpoch();
        return true;
    }

    public void notifyClose() {
        this.log.debug("Set the metadata for next ShareFetch request to close the share session memberId={}", (Object)this.nextMetadata.memberId());
        this.nextMetadata = this.nextMetadata.finalEpoch();
    }

    public void handleError(Throwable t) {
        this.log.info("Error sending fetch request {} to node {}:", new Object[]{this.nextMetadata, this.node, t});
        this.nextMetadata = this.nextMetadata.nextCloseExistingAttemptNew();
    }
}

