/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Locale;
import java.util.Optional;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.requests.JoinGroupRequest;

public class GroupRebalanceConfig {
    public final int sessionTimeoutMs;
    public final int rebalanceTimeoutMs;
    public final int heartbeatIntervalMs;
    public final String groupId;
    public final Optional<String> groupInstanceId;
    public final Optional<String> rackId;
    public final long retryBackoffMs;
    public final long retryBackoffMaxMs;

    public GroupRebalanceConfig(AbstractConfig config, ProtocolType protocolType) {
        this.sessionTimeoutMs = config.getInt("session.timeout.ms");
        if (protocolType == ProtocolType.CONSUMER || protocolType == ProtocolType.SHARE) {
            this.rebalanceTimeoutMs = config.getInt("max.poll.interval.ms");
            String rackId = config.getString("client.rack");
            this.rackId = rackId == null || rackId.isEmpty() ? Optional.empty() : Optional.of(rackId);
        } else {
            this.rebalanceTimeoutMs = config.getInt("rebalance.timeout.ms");
            this.rackId = Optional.empty();
        }
        this.heartbeatIntervalMs = config.getInt("heartbeat.interval.ms");
        this.groupId = config.getString("group.id");
        if (protocolType == ProtocolType.CONSUMER) {
            String groupInstanceId = config.getString("group.instance.id");
            if (groupInstanceId != null) {
                JoinGroupRequest.validateGroupInstanceId(groupInstanceId);
                this.groupInstanceId = Optional.of(groupInstanceId);
            } else {
                this.groupInstanceId = Optional.empty();
            }
        } else {
            this.groupInstanceId = Optional.empty();
        }
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
        this.retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
    }

    public GroupRebalanceConfig(int sessionTimeoutMs, int rebalanceTimeoutMs, int heartbeatIntervalMs, String groupId, Optional<String> groupInstanceId, String rackId, long retryBackoffMs, long retryBackoffMaxMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.groupId = groupId;
        this.groupInstanceId = groupInstanceId;
        this.rackId = rackId == null || rackId.isEmpty() ? Optional.empty() : Optional.of(rackId);
        this.retryBackoffMs = retryBackoffMs;
        this.retryBackoffMaxMs = retryBackoffMaxMs;
    }

    public static enum ProtocolType {
        CONSUMER,
        CONNECT,
        SHARE;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

