/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.quota;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.server.quota.SensorAccess;

public class RLMQuotaMetrics
implements AutoCloseable {
    private final SensorAccess sensorAccess;
    private final Metrics metrics;
    private final String name;
    private final String descriptionFormat;
    private final String group;
    private final long expirationTime;

    public RLMQuotaMetrics(Metrics metrics, String name, String group, String descriptionFormat, long expirationTime) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.sensorAccess = new SensorAccess((ReadWriteLock)lock, metrics);
        this.metrics = metrics;
        this.name = name;
        this.group = group;
        this.expirationTime = expirationTime;
        this.descriptionFormat = descriptionFormat;
    }

    public Sensor sensor() {
        return this.sensorAccess.getOrCreate(this.name, this.expirationTime, s -> {
            s.add(this.metrics.metricName(this.name + "-avg", this.group, String.format(this.descriptionFormat, "average")), (MeasurableStat)new Avg());
            s.add(this.metrics.metricName(this.name + "-max", this.group, String.format(this.descriptionFormat, "maximum")), (MeasurableStat)new Max());
        });
    }

    @Override
    public void close() {
        this.metrics.removeSensor(this.name);
    }
}

