/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.VersionRange;

public final class NodeMetrics
implements AutoCloseable {
    private static final String METRIC_GROUP_NAME = "node-metrics";
    private static final String FEATURE_NAME_TAG = "feature-name";
    private static final String MAXIMUM_SUPPORTED_LEVEL_NAME = "maximum-supported-level";
    private static final String MINIMUM_SUPPORTED_LEVEL_NAME = "minimum-supported-level";
    private final Metrics metrics;
    private final Map<String, VersionRange> supportedFeatureRanges;

    public NodeMetrics(Metrics metrics, boolean enableUnstableVersions) {
        this.metrics = metrics;
        this.supportedFeatureRanges = QuorumFeatures.defaultSupportedFeatureMap((boolean)enableUnstableVersions);
        this.supportedFeatureRanges.forEach((featureName, versionRange) -> {
            this.addSupportedLevelMetric(MAXIMUM_SUPPORTED_LEVEL_NAME, (String)featureName, versionRange.max());
            this.addSupportedLevelMetric(MINIMUM_SUPPORTED_LEVEL_NAME, (String)featureName, versionRange.min());
        });
    }

    private void addSupportedLevelMetric(String metricName, String featureName, short value) {
        this.metrics.addMetric(this.getFeatureNameTagMetricName(metricName, METRIC_GROUP_NAME, featureName), (MetricValueProvider)((Gauge)(config, now) -> value));
    }

    @Override
    public void close() {
        for (String featureName : this.supportedFeatureRanges.keySet()) {
            this.metrics.removeMetric(this.getFeatureNameTagMetricName(MAXIMUM_SUPPORTED_LEVEL_NAME, METRIC_GROUP_NAME, featureName));
            this.metrics.removeMetric(this.getFeatureNameTagMetricName(MINIMUM_SUPPORTED_LEVEL_NAME, METRIC_GROUP_NAME, featureName));
        }
    }

    private MetricName getFeatureNameTagMetricName(String name, String group, String featureName) {
        return this.metrics.metricName(name, group, Map.of(FEATURE_NAME_TAG, featureName.replace(".", "-")));
    }
}

