/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.ttl_test.test.turtle;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.ttl_test.TestFactoryManifestOld;
import org.apache.jena.util.junit.TestUtils;
import org.apache.jena.vocabulary.RDF;

public class TurtleTestFactory extends TestFactoryManifestOld {

    public static TestSuite make(String filename) {
        return new TurtleTestFactory().process(filename);
    }

    @Override
    public Test makeTest(Resource manifest, Resource item, String testName, Resource action, Resource result) {
        try {
            Resource r = TestUtils.getResource(item, RDF.type);
            Resource input = TestUtils.getResource(action, TurtleTestVocab.input);
            Resource output = TestUtils.getResource(result, TurtleTestVocab.output);
            Resource inputIRIr = TestUtils.getResource(action, TurtleTestVocab.inputIRI);
            String baseIRI = (inputIRIr == null) ? null : inputIRIr.getURI();

            if ( r.equals(TurtleTestVocab.TestInOut) ) {
                System.out.printf("TestInOut %s, in:%s, out:%s, base=%s\n", testName, input.getURI(), output.getURI(), baseIRI);
                return new TestItemTurtleExec(testName, input.getURI(), output.getURI(), baseIRI);
            }

            if ( r.equals(TurtleTestVocab.TestSyntax) ) {
                System.out.printf("TestSynGood %s, in:%s\n", testName, input.getURI());
                return new TestItemSyntax(testName, input.getURI());
            }

            if ( r.equals(TurtleTestVocab.TestBadSyntax) ) {
                System.out.printf("TestSynBad %s, in:%s, out:%s, base=%s\n", testName, input.getURI(), output.getURI(), baseIRI);
                return new TestItemBadSyntax(testName, input.getURI());
            }

            // if ( r.equals(TurtleTestVocab.TestSurpeessed ))
            // return new TestSupressed(testName, null);

            System.err.println("Unrecognized test : " + testName);
            return null;

        } catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Failed to grok test : " + testName);
            return null;
        }

    }
}
