/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.MeterConvention;
import io.micrometer.core.instrument.binder.jvm.convention.JvmThreadMeterConventions;
import io.micrometer.core.instrument.binder.jvm.convention.micrometer.MicrometerJvmThreadMeterConventions;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;

public class JvmThreadMetrics
implements MeterBinder {
    private final Tags extraTags;
    private final JvmThreadMeterConventions conventions;

    public JvmThreadMetrics() {
        this(Collections.emptyList());
    }

    public JvmThreadMetrics(Iterable<Tag> extraTags) {
        this(extraTags, new MicrometerJvmThreadMeterConventions(Tags.of(extraTags)));
    }

    public JvmThreadMetrics(Iterable<? extends Tag> extraTags, JvmThreadMeterConventions conventions) {
        this.extraTags = Tags.of(extraTags);
        this.conventions = conventions;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Gauge.builder("jvm.threads.peak", threadBean, ThreadMXBean::getPeakThreadCount).tags(this.extraTags).description("The peak live thread count since the Java virtual machine started or peak was reset").baseUnit("threads").register(registry);
        Gauge.builder("jvm.threads.daemon", threadBean, ThreadMXBean::getDaemonThreadCount).tags(this.extraTags).description("The current number of live daemon threads").baseUnit("threads").register(registry);
        Gauge.builder("jvm.threads.live", threadBean, ThreadMXBean::getThreadCount).tags(this.extraTags).description("The current number of live threads including both daemon and non-daemon threads").baseUnit("threads").register(registry);
        FunctionCounter.builder("jvm.threads.started", threadBean, ThreadMXBean::getTotalStartedThreadCount).tags(this.extraTags).description("The total number of application threads started in the JVM").baseUnit("threads").register(registry);
        try {
            threadBean.getAllThreadIds();
            MeterConvention<Thread.State> threadCountConvention = this.conventions.threadCountConvention();
            for (Thread.State state : Thread.State.values()) {
                Gauge.builder(threadCountConvention.getName(), threadBean, bean -> JvmThreadMetrics.getThreadStateCount(bean, state)).tags(threadCountConvention.getTags(state)).description("The current number of threads").baseUnit("threads").register(registry);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        return Arrays.stream(threadBean.getThreadInfo(threadBean.getAllThreadIds())).filter(threadInfo -> threadInfo != null && threadInfo.getThreadState() == state).count();
    }
}

