/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanWeight;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

abstract class SpanContainQuery
extends SpanQuery
implements Cloneable {
    SpanQuery big;
    SpanQuery little;

    SpanContainQuery(SpanQuery big, SpanQuery little) {
        this.big = Objects.requireNonNull(big);
        this.little = Objects.requireNonNull(little);
        Objects.requireNonNull(big.getField());
        Objects.requireNonNull(little.getField());
        if (!big.getField().equals(little.getField())) {
            throw new IllegalArgumentException("big and little not same field");
        }
    }

    @Override
    public String getField() {
        return this.big.getField();
    }

    public SpanQuery getBig() {
        return this.big;
    }

    public SpanQuery getLittle() {
        return this.little;
    }

    String toString(String field, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        buffer.append("(");
        buffer.append(this.big.toString(field));
        buffer.append(", ");
        buffer.append(this.little.toString(field));
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        SpanQuery rewrittenBig = (SpanQuery)this.big.rewrite(indexSearcher);
        SpanQuery rewrittenLittle = (SpanQuery)this.little.rewrite(indexSearcher);
        if (this.big != rewrittenBig || this.little != rewrittenLittle) {
            try {
                SpanContainQuery clone = (SpanContainQuery)super.clone();
                clone.big = rewrittenBig;
                clone.little = rewrittenLittle;
                return clone;
            }
            catch (CloneNotSupportedException e2) {
                throw new AssertionError((Object)e2);
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
            this.big.visit(v);
            this.little.visit(v);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanContainQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanContainQuery other) {
        return this.big.equals(other.big) && this.little.equals(other.little);
    }

    @Override
    public int hashCode() {
        int h = Integer.rotateLeft(this.classHash(), 1);
        h ^= this.big.hashCode();
        h = Integer.rotateLeft(h, 1);
        return h ^= this.little.hashCode();
    }

    public abstract class SpanContainWeight
    extends SpanWeight {
        final SpanWeight bigWeight;
        final SpanWeight littleWeight;

        public SpanContainWeight(SpanContainQuery this$0, IndexSearcher searcher, Map<Term, TermStates> terms, SpanWeight bigWeight, SpanWeight littleWeight, float boost) throws IOException {
            super(this$0, searcher, terms, boost);
            this.bigWeight = bigWeight;
            this.littleWeight = littleWeight;
        }

        ArrayList<Spans> prepareConjunction(LeafReaderContext context2, SpanWeight.Postings postings) throws IOException {
            Spans bigSpans = this.bigWeight.getSpans(context2, postings);
            if (bigSpans == null) {
                return null;
            }
            Spans littleSpans = this.littleWeight.getSpans(context2, postings);
            if (littleSpans == null) {
                return null;
            }
            ArrayList<Spans> bigAndLittle = new ArrayList<Spans>();
            bigAndLittle.add(bigSpans);
            bigAndLittle.add(littleSpans);
            return bigAndLittle;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            this.bigWeight.extractTermStates(contexts);
            this.littleWeight.extractTermStates(contexts);
        }
    }
}

