/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class DiffColumnTransformer
extends BinaryColumnTransformer {
    private double lastValue;
    private boolean lastValueIsNull = true;

    public DiffColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        Type leftType = this.leftTransformer.getType();
        Type rightType = this.rightTransformer.getType();
        for (int i = 0; i < positionCount; ++i) {
            if (leftColumn.isNull(i)) {
                builder.appendNull();
                this.lastValueIsNull |= rightColumn.isNull(i) || !rightType.getBoolean(rightColumn, i);
                continue;
            }
            double currValue = leftType.getDouble(leftColumn, i);
            if (this.lastValueIsNull) {
                builder.appendNull();
            } else {
                this.returnType.writeDouble(builder, currValue - this.lastValue);
            }
            this.lastValue = currValue;
            this.lastValueIsNull = false;
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        this.doTransform(leftColumn, rightColumn, builder, positionCount);
    }
}

