/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.IDeviceSchema;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableAttributeSchema
implements IDeviceSchema {
    static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(TableAttributeSchema.class) + (int)RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    private final Map<String, Binary> attributeMap = new ConcurrentHashMap<String, Binary>();

    public int updateAttribute(String database, String tableName, @Nonnull Map<String, Binary> updateMap) {
        AtomicInteger diff = new AtomicInteger(0);
        updateMap.forEach((k, v) -> {
            if (v != Binary.EMPTY_VALUE) {
                if (!this.attributeMap.containsKey(k) && Objects.isNull(k = DataNodeTableCache.getInstance().tryGetInternColumnName(database, tableName, (String)k))) {
                    return;
                }
                Binary previousValue = this.attributeMap.put((String)k, (Binary)v);
                long newValueSize = UpdateDetailContainer.sizeOf(v);
                diff.addAndGet((int)(Objects.nonNull(previousValue) ? newValueSize - UpdateDetailContainer.sizeOf(previousValue) : RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + newValueSize));
            } else {
                this.attributeMap.remove(k);
                diff.addAndGet((int)(-RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY - UpdateDetailContainer.sizeOf(v)));
            }
        });
        return diff.get();
    }

    public int removeAttribute(String attribute) {
        Binary previousValue = this.attributeMap.remove(attribute);
        return Objects.nonNull(previousValue) ? (int)(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + UpdateDetailContainer.sizeOf(previousValue)) : 0;
    }

    public Map<String, Binary> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public int estimateSize() {
        return INSTANCE_SIZE + (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY * this.attributeMap.size() + this.attributeMap.values().stream().mapToInt(attrValue -> (int)attrValue.ramBytesUsed()).reduce(0, Integer::sum);
    }
}

