/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read;

import java.io.IOException;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.tsfile.read.expression.QueryExpression;
import org.apache.tsfile.read.query.dataset.QueryDataSet;
import org.apache.tsfile.read.query.executor.TsFileExecutor;

public class TsFileReader
implements AutoCloseable {
    private TsFileSequenceReader fileReader;
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;
    private TsFileExecutor tsFileExecutor;

    public TsFileReader(TsFileSequenceReader fileReader) throws IOException {
        this.fileReader = fileReader;
        this.metadataQuerier = new MetadataQuerierByFileImpl(fileReader);
        this.chunkLoader = new CachedChunkLoaderImpl(fileReader);
        this.tsFileExecutor = new TsFileExecutor(this.metadataQuerier, this.chunkLoader);
    }

    public QueryDataSet query(QueryExpression queryExpression) throws IOException {
        return this.tsFileExecutor.execute(queryExpression);
    }

    public QueryDataSet query(QueryExpression queryExpression, long partitionStartOffset, long partitionEndOffset) throws IOException {
        return this.tsFileExecutor.execute(queryExpression, partitionStartOffset, partitionEndOffset);
    }

    @Override
    public void close() throws IOException {
        this.fileReader.close();
    }
}

