/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import org.apache.dubbo.config.annotation.Service;
import org.apache.ozhera.prometheus.agent.Commons;
import org.apache.ozhera.prometheus.agent.api.service.PrometheusScrapeJobService;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.prometheus.ScrapeJobService;
import org.springframework.beans.factory.annotation.Autowired;

@Service(timeout=5000, group="${dubbo.group}")
public class PrometheusScrapeJobImpl
implements PrometheusScrapeJobService {
    @Autowired
    ScrapeJobService scrapeJobService;

    public Result CreateScrapeConfig(ScrapeConfigParam param) {
        return this.scrapeJobService.CreateScrapeConfig(param);
    }

    public Result DeleteScrapeConfig(String id) {
        return this.scrapeJobService.DeleteScrapeConfig(id);
    }

    public Result UpdateScrapeConfig(String id, ScrapeConfigParam entity) {
        Result result = this.scrapeJobService.UpdateScrapeConfig(id, entity);
        return result;
    }

    public Result GetScrapeConfig(String id) {
        return this.scrapeJobService.GetScrapeConfig(id);
    }

    public Result GetScrapeConfigByName(String name) {
        return this.scrapeJobService.GetScrapeConfigByName(name);
    }

    public Result GetScrapeConfigList(Integer page_size, Integer page_no) {
        if (page_size == null && page_no == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (page_size == null) {
            page_size = Commons.COMMON_PAGE_SIZE;
        }
        if (page_no == null) {
            page_no = Commons.COMMON_PAGE_NO;
        }
        Result result = this.scrapeJobService.GetScrapeConfigList(page_size, page_no);
        return result;
    }
}

