/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.telnet.support.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.Help;
import org.apache.dubbo.remoting.telnet.support.TelnetUtils;

@Activate
@Help(parameter="[command]", summary="Show help.", detail="Show help.")
public class HelpTelnetHandler
implements TelnetHandler {
    private final ExtensionLoader<TelnetHandler> extensionLoader = ExtensionLoader.getExtensionLoader(TelnetHandler.class);
    private static final String MAIN_HELP = "mainHelp";
    private static Map<String, String> processedTable = new WeakHashMap<String, String>();

    @Override
    public String telnet(Channel channel, String message) {
        if (message.length() > 0) {
            return processedTable.computeIfAbsent(message, commandName -> this.generateForOneCommand((String)commandName));
        }
        return processedTable.computeIfAbsent(MAIN_HELP, commandName -> this.generateForAllCommand(channel));
    }

    private String generateForOneCommand(String message) {
        if (!this.extensionLoader.hasExtension(message)) {
            return "No such command " + message;
        }
        TelnetHandler handler = this.extensionLoader.getExtension(message);
        Help help = handler.getClass().getAnnotation(Help.class);
        StringBuilder buf = new StringBuilder();
        buf.append("Command:\r\n    ");
        buf.append(message + " " + help.parameter().replace("\r\n", " ").replace("\n", " "));
        buf.append("\r\nSummary:\r\n    ");
        buf.append(help.summary().replace("\r\n", " ").replace("\n", " "));
        buf.append("\r\nDetail:\r\n    ");
        buf.append(help.detail().replace("\r\n", "    \r\n").replace("\n", "    \n"));
        return buf.toString();
    }

    private String generateForAllCommand(Channel channel) {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        List<TelnetHandler> handlers = this.extensionLoader.getActivateExtension(channel.getUrl(), "telnet");
        if (CollectionUtils.isNotEmpty(handlers)) {
            for (TelnetHandler handler : handlers) {
                Help help = handler.getClass().getAnnotation(Help.class);
                ArrayList<String> row = new ArrayList<String>();
                String parameter = " " + this.extensionLoader.getExtensionName(handler) + " " + (help != null ? help.parameter().replace("\r\n", " ").replace("\n", " ") : "");
                row.add(parameter.length() > 55 ? parameter.substring(0, 55) + "..." : parameter);
                String summary = help != null ? help.summary().replace("\r\n", " ").replace("\n", " ") : "";
                row.add(summary.length() > 55 ? summary.substring(0, 55) + "..." : summary);
                table.add(row);
            }
        }
        return "Please input \"help [command]\" show detail.\r\n" + TelnetUtils.toList(table);
    }
}

