/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multiple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.DefaultPage;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.event.ConditionalEventListener;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

public class MultipleRegistryServiceDiscovery
extends AbstractServiceDiscovery {
    public static final String REGISTRY_PREFIX_KEY = "child.";
    private final Map<String, ServiceDiscovery> serviceDiscoveries = new ConcurrentHashMap<String, ServiceDiscovery>();
    private URL registryURL;
    private String applicationName;

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.registryURL = registryURL;
        this.applicationName = registryURL.getParameter("application");
        Map<String, String> parameters = registryURL.getParameters();
        for (String key : parameters.keySet()) {
            if (!key.startsWith(REGISTRY_PREFIX_KEY)) continue;
            URL url = URL.valueOf(registryURL.getParameter(key)).addParameter("application", this.applicationName).addParameter("registry-type", "service");
            ServiceDiscovery serviceDiscovery = ServiceDiscoveryFactory.getExtension(url).getServiceDiscovery(url);
            serviceDiscovery.initialize(url);
            this.serviceDiscoveries.put(key, serviceDiscovery);
        }
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    @Override
    public void destroy() throws Exception {
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            serviceDiscovery.destroy();
        }
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.register(serviceInstance));
    }

    @Override
    public void doUpdate(ServiceInstance serviceInstance) {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.update(serviceInstance));
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceDiscoveries.values().forEach(serviceDiscovery -> serviceDiscovery.unregister(serviceInstance));
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        MultiServiceInstancesChangedListener multiListener = new MultiServiceInstancesChangedListener(listener);
        for (String registryKey : this.serviceDiscoveries.keySet()) {
            SingleServiceInstancesChangedListener singleListener = new SingleServiceInstancesChangedListener(listener.getServiceNames(), this.serviceDiscoveries.get(registryKey), multiListener);
            multiListener.putSingleListener(registryKey, singleListener);
            this.serviceDiscoveries.get(registryKey).addServiceInstancesChangedListener(singleListener);
        }
    }

    @Override
    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        ArrayList<ServiceInstance> serviceInstanceList = new ArrayList<ServiceInstance>();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            Page<ServiceInstance> serviceInstancePage = serviceDiscovery.getInstances(serviceName, offset, pageSize, healthyOnly);
            if (!CollectionUtils.isNotEmpty(serviceInstancePage.getData())) continue;
            for (ServiceInstance instance : serviceInstancePage.getData()) {
                if (serviceInstanceList.contains(instance)) continue;
                serviceInstanceList.add(instance);
            }
        }
        return new DefaultPage<ServiceInstance>(offset, pageSize, serviceInstanceList, serviceInstanceList.size());
    }

    @Override
    public Set<String> getServices() {
        HashSet<String> services = new HashSet<String>();
        for (ServiceDiscovery serviceDiscovery : this.serviceDiscoveries.values()) {
            services.addAll(serviceDiscovery.getServices());
        }
        return services;
    }

    @Override
    public ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    protected static class SingleServiceInstancesChangedListener
    extends ServiceInstancesChangedListener {
        private final MultiServiceInstancesChangedListener multiListener;
        volatile ServiceInstancesChangedEvent event;

        public SingleServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery, MultiServiceInstancesChangedListener multiListener) {
            super(serviceNames, serviceDiscovery);
            this.multiListener = multiListener;
        }

        @Override
        public void onEvent(ServiceInstancesChangedEvent event) {
            this.event = event;
            if (this.multiListener != null) {
                this.multiListener.onEvent(event);
            }
        }
    }

    protected static class MultiServiceInstancesChangedListener
    implements ConditionalEventListener<ServiceInstancesChangedEvent> {
        private final ServiceInstancesChangedListener sourceListener;
        private final Map<String, SingleServiceInstancesChangedListener> singleListenerMap = new ConcurrentHashMap<String, SingleServiceInstancesChangedListener>();

        public MultiServiceInstancesChangedListener(ServiceInstancesChangedListener sourceListener) {
            this.sourceListener = sourceListener;
        }

        @Override
        public boolean accept(ServiceInstancesChangedEvent event) {
            return this.sourceListener.getServiceNames().contains(event.getServiceName());
        }

        @Override
        public void onEvent(ServiceInstancesChangedEvent event) {
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
            for (SingleServiceInstancesChangedListener singleListener : this.singleListenerMap.values()) {
                ServiceInstancesChangedEvent source = singleListener.event;
                if (source == null || source.getServiceInstances() == null) continue;
                for (ServiceInstance serviceInstance : source.getServiceInstances()) {
                    if (serviceInstances.contains(serviceInstance)) continue;
                    serviceInstances.add(serviceInstance);
                }
            }
            this.sourceListener.onEvent(new ServiceInstancesChangedEvent(event.getServiceName(), serviceInstances));
        }

        public void putSingleListener(String registryKey, SingleServiceInstancesChangedListener singleListener) {
            this.singleListenerMap.put(registryKey, singleListener);
        }
    }
}

