/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.graphql.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.test.tester.ExecutionGraphQlServiceTester;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;

@AutoConfiguration(after={JacksonAutoConfiguration.class, GraphQlAutoConfiguration.class})
@ConditionalOnClass(value={GraphQL.class, GraphQlTester.class})
public class GraphQlTesterAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={ExecutionGraphQlService.class})
    @ConditionalOnMissingBean
    public ExecutionGraphQlServiceTester graphQlTester(ExecutionGraphQlService graphQlService, ObjectProvider<ObjectMapper> objectMapperProvider) {
        ExecutionGraphQlServiceTester.Builder builder = ExecutionGraphQlServiceTester.builder((ExecutionGraphQlService)graphQlService);
        objectMapperProvider.ifAvailable(objectMapper -> {
            MediaType[] mediaTypes = new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL};
            builder.encoder((Encoder)new Jackson2JsonEncoder(objectMapper, (MimeType[])mediaTypes));
            builder.decoder((Decoder)new Jackson2JsonDecoder(objectMapper, (MimeType[])mediaTypes));
        });
        return builder.build();
    }
}

