/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.http2;

import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.HttpHandlerRead;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2OrHttpHandler
extends ApplicationProtocolNegotiationHandler {
    private static final Logger log = LoggerFactory.getLogger(Http2OrHttpHandler.class);
    private HttpServerConfig config;

    public Http2OrHttpHandler(HttpServerConfig config) {
        super("http/1.1");
        this.config = config;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()});
            ctx.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

                        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
                            HttpHandlerRead.read(ctx, msg, Http2OrHttpHandler.this.config);
                        }
                    }});
                }
            })});
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }
}

