/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.protocol;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.xiaomi.data.push.rpc.RpcException;
import com.xiaomi.data.push.rpc.protocol.RemotingCommandType;
import com.xiaomi.data.push.rpc.protocol.RemotingSerializable;
import com.xiaomi.data.push.rpc.protocol.SerializaType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class RemotingCommand {
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private static volatile int configVersion = 1;
    private static AtomicInteger requestId = new AtomicInteger(0);
    private int code;
    private int version = 0;
    private int opaque = requestId.getAndIncrement();
    private int flag = 0;
    private long timeout = 1000L;
    private String address;
    private int serializeType = SerializaType.json.ordinal();
    private static Gson gson = new Gson();
    private String remark;
    private HashMap<String, String> extFields = null;
    private transient byte[] body;
    private transient int bodyLen;

    public static RemotingCommand createRequestCommand(int code) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    public static RemotingCommand createGsonRequestCommand(int code, Object body, Gson customGson) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        RemotingCommand.setCmdVersion(cmd);
        cmd.setBody(customGson.toJson(body).getBytes(StandardCharsets.UTF_8));
        return cmd;
    }

    public static RemotingCommand createGsonRequestCommand(int code, Object body) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        RemotingCommand.setCmdVersion(cmd);
        cmd.setBody(gson.toJson(body).getBytes(StandardCharsets.UTF_8));
        return cmd;
    }

    public static RemotingCommand createMsgPackRequest(int code, Object body) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        RemotingCommand.setCmdVersion(cmd);
        cmd.setSerializeType(SerializaType.msgpack.ordinal());
        try {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
            byte[] data = objectMapper.writeValueAsBytes(body);
            cmd.setBody(data);
        }
        catch (JsonProcessingException e) {
            throw new RpcException(e.getMessage(), e);
        }
        return cmd;
    }

    public static RemotingCommand createRequestCommand(int code, int bodyLen) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        RemotingCommand.setCmdVersion(cmd);
        cmd.setBodyLen(bodyLen);
        return cmd;
    }

    private static void setCmdVersion(RemotingCommand cmd) {
        cmd.setVersion(configVersion);
    }

    public void markResponseType() {
        int bits = 1;
        this.flag |= bits;
    }

    public <T> T getReq(Class<T> clazz) {
        if (this.serializeType == 0) {
            String body = new String(this.body);
            return (T)new Gson().fromJson(body, clazz);
        }
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        try {
            return (T)objectMapper.readValue(this.body, clazz);
        }
        catch (IOException e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public static RemotingCommand createResponseCommand(int code) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        return cmd;
    }

    public static RemotingCommand createMsgpackResponse(int code, Object body) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setSerializeType(SerializaType.msgpack.ordinal());
        try {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
            byte[] data = objectMapper.writeValueAsBytes(body);
            cmd.setBody(data);
        }
        catch (JsonProcessingException e) {
            throw new RpcException(e.getMessage(), e);
        }
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, int bodyLen) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setBodyLen(bodyLen);
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String body) {
        return RemotingCommand.createResponseCommand(code, body.getBytes());
    }

    public static RemotingCommand createResponseCommand(int code, byte[] body) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setBody(body);
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) {
        int length = byteBuffer.limit();
        int headerLength = byteBuffer.getInt();
        byte[] headerData = new byte[headerLength];
        byteBuffer.get(headerData);
        RemotingCommand cmd = RemotingCommand.headerDecode(headerData);
        int bodyLength = length - 4 - headerLength;
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.get(bodyData);
        }
        cmd.body = bodyData;
        return cmd;
    }

    private static RemotingCommand headerDecode(byte[] headerData) {
        return RemotingSerializable.decode(headerData, RemotingCommand.class);
    }

    public static int createNewRequestId() {
        return requestId.incrementAndGet();
    }

    public ByteBuffer encode() {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        if (this.body != null) {
            length += this.body.length;
        }
        if (this.bodyLen != 0) {
            length += this.bodyLen;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.putInt(headerData.length);
        result.put(headerData);
        if (this.body != null) {
            result.put(this.body);
        }
        result.flip();
        return result;
    }

    private byte[] headerEncode() {
        return RemotingSerializable.encode(this);
    }

    public ByteBuffer encodeHeader() {
        int bodyLen = 0;
        if (null != this.body) {
            bodyLen = this.body.length;
        }
        if (this.bodyLen > 0) {
            bodyLen = this.bodyLen;
        }
        return this.encodeHeader(bodyLen);
    }

    public ByteBuffer encodeHeader(int bodyLength) {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        ByteBuffer result = ByteBuffer.allocate(4 + (length += bodyLength) - bodyLength);
        result.putInt(length);
        result.putInt(headerData.length);
        result.put(headerData);
        result.flip();
        return result;
    }

    public void markOnewayRPC() {
        int bits = 2;
        this.flag |= bits;
    }

    public boolean isOnewayRPC() {
        int bits = 2;
        return (this.flag & bits) == bits;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    public boolean isResponseType() {
        int bits = 1;
        return (this.flag & bits) == bits;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public String getExtField(String key) {
        return this.extFields.get(key);
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public void addExtField(String key, String value) {
        if (null == this.extFields) {
            this.extFields = new HashMap(1);
        }
        this.extFields.put(key, value);
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", opaque=" + this.opaque + "]";
    }

    public void setApp(String app) {
        this.addExtField("app", app);
    }

    public void setMethodName(String name) {
        this.addExtField("methodName", name);
    }

    public int getRetries() {
        return 1;
    }

    public String getMessage() {
        return this.extFields.get("message");
    }

    public String servcieName() {
        return this.extFields.get("servcieName");
    }

    public void setServiceName(String serviceName) {
        this.addExtField("serviceName", serviceName);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setSerializeType(int serializeType) {
        this.serializeType = serializeType;
    }

    public int getSerializeType() {
        return this.serializeType;
    }

    public void setBodyLen(int bodyLen) {
        this.bodyLen = bodyLen;
    }
}

