/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.utils;

import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SimilarUtils {
    public static String findHighestSimilarityStr(String baseStr, List<String> strList) {
        String strR = "";
        if (1 == strList.size()) {
            strR = strList.get(0);
        } else {
            for (String s : strList) {
                if (!baseStr.contains(s)) continue;
                strR = s;
            }
        }
        if (StringUtils.isEmpty((CharSequence)strR)) {
            strR = (String)strList.stream().sorted((o1, o2) -> Double.compare(SimilarUtils.computeSimilarity(baseStr, o2), SimilarUtils.computeSimilarity(baseStr, o1))).findFirst().get();
        }
        return strR;
    }

    public static double computeSimilarity(String str1, String str2) {
        int levenshteinDistance = SimilarUtils.computeLevenshteinDistance(str1, str2);
        int maxLen = Math.max(str1.length(), str2.length());
        return (1.0 - (double)levenshteinDistance / (double)maxLen) * 100.0;
    }

    private static int computeLevenshteinDistance(String str1, String str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = SimilarUtils.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

