/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.io.Serializable;
import org.nutz.dao.impl.sql.VarIndexImpl;
import org.nutz.dao.impl.sql.WorkingStack;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.sql.VarIndex;
import org.nutz.lang.Strings;

public class SqlLiteral
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    WorkingStack stack;
    private VarIndexImpl varIndexes;
    private VarIndexImpl paramIndexes;
    private String source;
    private SqlType type;
    private char paramChar;
    private char varChar;

    public SqlLiteral() {
        this('@', '$');
    }

    public SqlLiteral(char paramChar, char varChar) {
        this.paramChar = paramChar;
        this.varChar = varChar;
    }

    private void reset() {
        this.stack = new WorkingStack();
        this.varIndexes = new VarIndexImpl();
        this.paramIndexes = new VarIndexImpl();
    }

    VarIndex getVarIndexes() {
        return this.varIndexes;
    }

    VarIndex getParamIndexes() {
        return this.paramIndexes;
    }

    SqlLiteral valueOf(String str) {
        this.reset();
        this.source = str;
        if (null == this.source) {
            return this;
        }
        char[] cs = Strings.trim(this.source).toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            StringBuilder sb;
            char c = cs[i];
            if (c == this.paramChar) {
                if (cs[i + 1] == c) {
                    this.stack.push(c);
                    ++i;
                    continue;
                }
                sb = new StringBuilder();
                i = SqlLiteral.readTokenName(cs, i, sb);
                if (sb.length() == 0) {
                    this.stack.push(c);
                    continue;
                }
                this.paramIndexes.add(sb.toString(), this.stack.markToken());
                continue;
            }
            if (c == this.varChar) {
                if (cs[i + 1] == this.varChar) {
                    this.stack.push(c);
                    ++i;
                    continue;
                }
                sb = new StringBuilder();
                i = SqlLiteral.readTokenName(cs, i, sb);
                if (sb.length() == 0) {
                    this.stack.push(c);
                    continue;
                }
                this.varIndexes.add(sb.toString(), this.stack.markToken());
                continue;
            }
            this.stack.push(c);
        }
        this.stack.finish();
        this.type = this.stack.firstEquals("SELECT") || this.stack.firstEquals("WITH") ? SqlType.SELECT : (this.stack.firstEquals("UPDATE") ? SqlType.UPDATE : (this.stack.firstEquals("INSERT") ? SqlType.INSERT : (this.stack.firstEquals("DELETE") ? SqlType.DELETE : (this.stack.firstEquals("CREATE") ? SqlType.CREATE : (this.stack.firstEquals("DROP") ? SqlType.DROP : (this.stack.firstEquals("TRUNCATE") ? SqlType.TRUNCATE : (this.stack.firstEquals("ALTER") ? SqlType.ALTER : (this.stack.firstEquals("EXEC") ? SqlType.EXEC : (this.stack.firstEquals("CALL") ? SqlType.CALL : (this.stack.firstEquals("{CALL") ? SqlType.CALL : SqlType.OTHER))))))))));
        return this;
    }

    private static int readTokenName(char[] cs, int i, StringBuilder sb) {
        if (cs[i + 1] == '{') {
            i += 2;
            while (i < cs.length) {
                if (cs[i] == '}') {
                    return i;
                }
                sb.append(cs[i]);
                ++i;
            }
            return i;
        }
        ++i;
        while (i < cs.length) {
            char b = cs[i];
            if (b == '_') {
                sb.append(b);
            } else {
                if (b == '$') {
                    return i;
                }
                if (b >= '\u0000' && b <= '/' || b >= ':' && b <= '@' || b >= '[' && b <= '`' || b >= '{' && b <= '\u00a0') break;
                sb.append(b);
            }
            ++i;
        }
        return i - 1;
    }

    public SqlLiteral clone() {
        return new SqlLiteral(this.paramChar, this.varChar).valueOf(this.source);
    }

    public String toString() {
        return this.source;
    }

    boolean isSELECT() {
        return SqlType.SELECT == this.type;
    }

    boolean isUPDATE() {
        return SqlType.UPDATE == this.type;
    }

    boolean isINSERT() {
        return SqlType.INSERT == this.type;
    }

    boolean isDELETE() {
        return SqlType.DELETE == this.type;
    }

    boolean isCREATE() {
        return SqlType.CREATE == this.type;
    }

    boolean isDROP() {
        return SqlType.DROP == this.type;
    }

    boolean isTRUNCATE() {
        return SqlType.TRUNCATE == this.type;
    }

    SqlType getType() {
        return this.type;
    }
}

