/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.entity;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.nutz.castor.Castors;
import org.nutz.dao.Chain;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.jdbc.BlobValueAdaptor;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;

public class Record
implements Map<String, Object>,
Serializable,
Cloneable,
Comparable<Record> {
    private static final long serialVersionUID = -7753504263747912181L;
    protected static Callable<Record> factory;
    private Map<String, Object> map = new LinkedHashMap<String, Object>();
    private List<String> keys = new ArrayList<String>();

    public static Record create(ResultSet rs) {
        Record re = Record.create();
        Record.create(re, rs, null);
        return re;
    }

    public static void create(Map<String, Object> re, ResultSet rs, ResultSetMetaData meta) {
        String name = null;
        int i = 0;
        try {
            if (meta == null) {
                meta = rs.getMetaData();
            }
            int count = meta.getColumnCount();
            block8: for (i = 1; i <= count; ++i) {
                name = meta.getColumnLabel(i);
                switch (meta.getColumnType(i)) {
                    case 93: {
                        re.put(name, rs.getTimestamp(i));
                        continue block8;
                    }
                    case 91: {
                        re.put(name, rs.getTimestamp(i));
                        continue block8;
                    }
                    case 2005: {
                        re.put(name, rs.getString(i));
                        continue block8;
                    }
                    case 2004: {
                        re.put(name, new BlobValueAdaptor(Jdbcs.getFilePool()).get(rs, name));
                        continue block8;
                    }
                    default: {
                        re.put(name, rs.getObject(i));
                    }
                }
            }
        }
        catch (SQLException e) {
            if (name != null) {
                throw new DaoException(String.format("Column Name=%s, index=%d", name, i), e);
            }
            throw new DaoException(e);
        }
    }

    public Record set(String name, Object value) {
        this.map.put(name.toLowerCase(), value);
        this.keys.add(name);
        return this;
    }

    public Object remove(String name) {
        this.keys.remove(name);
        return this.map.remove(name.toLowerCase());
    }

    public int getColumnCount() {
        return this.map.size();
    }

    public Set<String> getColumnNames() {
        return this.map.keySet();
    }

    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    public int getInt(String name, int dft) {
        try {
            Object val = this.get(name);
            if (null == val) {
                return dft;
            }
            return Castors.me().castTo(val, Integer.TYPE);
        }
        catch (Exception exception) {
            return dft;
        }
    }

    public long getLong(String name) {
        return this.getLong(name, -1L);
    }

    public long getLong(String name, long dft) {
        try {
            Object val = this.get(name);
            if (null == val) {
                return dft;
            }
            return Castors.me().castTo(val, Long.TYPE);
        }
        catch (Exception exception) {
            return dft;
        }
    }

    public double getDouble(String name) {
        return this.getDouble(name, -1.0);
    }

    public double getDouble(String name, double dft) {
        try {
            Object val = this.get(name);
            if (null == val) {
                return dft;
            }
            return Castors.me().castTo(val, Double.TYPE);
        }
        catch (Exception exception) {
            return dft;
        }
    }

    public String getString(String name) {
        Object val = this.get(name);
        if (null == val) {
            return null;
        }
        return Castors.me().castToString(val);
    }

    public Blob getBlob(String name) {
        Object val = this.get(name);
        if (null == val) {
            return null;
        }
        return Castors.me().castTo(val, Blob.class);
    }

    public Timestamp getTimestamp(String name) {
        Object val = this.get(name);
        if (null == val) {
            return null;
        }
        return Castors.me().castTo(val, Timestamp.class);
    }

    public String toJson(JsonFormat format) {
        return Json.toJson(this.map, format);
    }

    public String toString() {
        return Json.toJson(this.map, JsonFormat.full());
    }

    public <T> T toPojo(Class<T> type) {
        return Lang.map2Object(this, type);
    }

    public <T> T toEntity(Entity<T> en) {
        return en.getObject(this);
    }

    public <T> T toEntity(Entity<T> en, String prefix) {
        return en.getObject(this, prefix);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.keys.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key.toString().toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object out) {
        return this.map.equals(out);
    }

    @Override
    public Object get(Object name) {
        if (null == name) {
            return null;
        }
        return this.map.get(name.toString().toLowerCase());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String name, Object value) {
        this.keys.add(name);
        return this.map.put(name.toLowerCase(), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> out) {
        for (Map.Entry<? extends String, ? extends Object> entry : out.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key.toString().toLowerCase());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public Chain toChain() {
        return Chain.from(this.map);
    }

    public Record clone() {
        Record re = Record.create();
        re.putAll(this);
        return re;
    }

    public Map<String, Object> sensitive() {
        NutMap map = new NutMap();
        for (String key : this.keys) {
            map.put(key, this.get(key));
        }
        return map;
    }

    @Override
    public int compareTo(Record re) {
        if (re == null) {
            return 1;
        }
        if (re.size() == this.size()) {
            return 0;
        }
        return re.size() > this.size() ? -1 : 1;
    }

    public static void setFactory(Callable<Record> factory) {
        Record.factory = factory;
    }

    public static Record create() {
        if (factory != null) {
            try {
                return factory.call();
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new Record();
    }
}

