/*
 * Decompiled with CFR 0.152.
 */
package run.mone.excel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportExcel {
    public static HSSFWorkbook HSSFWorkbook(List<T> list) {
        int i;
        T t;
        HSSFWorkbook workbook = new HSSFWorkbook();
        workbook.createInformationProperties();
        HSSFCellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.GREEN.getIndex());
        HSSFSheet sheet = workbook.createSheet();
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            t = iterator.next();
            HSSFRow row = sheet.createRow(0);
            String[] fieldNames = ExportExcel.getFiledNames(t);
            for (i = 0; i < fieldNames.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellValue(fieldNames[i]);
                cell.setCellStyle(headerStyle);
            }
        }
        for (int j = 0; j < list.size(); ++j) {
            t = list.get(j);
            String[] fieldValues = ExportExcel.getFieldValues(t);
            HSSFRow rows = sheet.createRow(j + 1);
            for (i = 0; i < fieldValues.length; ++i) {
                rows.createCell(i).setCellValue(fieldValues[i]);
            }
        }
        return workbook;
    }

    public static HSSFWorkbook HSSFWorkbook4Map(List<Map<String, Object>> list, String title) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        if (title != null && !"".equals(title)) {
            HSSFRow titleRow = sheet.createRow(0);
            HSSFCell cell = titleRow.createCell(0);
            cell.setCellValue(title);
            HSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setAlignment((short)2);
            titleStyle.setVerticalAlignment((short)1);
            HSSFFont titleFont = workbook.createFont();
            titleFont.setBoldweight((short)700);
            titleStyle.setFont(titleFont);
            cell.setCellStyle(titleStyle);
            titleRow.setHeight((short)450);
            int endMergeCellIndex = list == null || list.isEmpty() ? 5 : list.get(0).size() - 1;
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, endMergeCellIndex));
        }
        if (list == null || list.isEmpty()) {
            return workbook;
        }
        HSSFCellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setAlignment((short)2);
        headerStyle.setBorderBottom((short)2);
        headerStyle.setBorderTop((short)2);
        int headRowIndex = title == null || "".equals(title) ? 0 : 1;
        HSSFRow headRow = sheet.createRow(headRowIndex);
        int i = 0;
        for (Map.Entry<String, Object> entry : list.get(0).entrySet()) {
            HSSFCell cell = headRow.createCell(i++);
            cell.setCellValue(entry.getKey());
            cell.setCellStyle(headerStyle);
        }
        int dataBeginRow = title == null || "".equals(title) ? 1 : 2;
        for (int j = 0; j < list.size(); ++j) {
            HSSFRow rows = sheet.createRow(dataBeginRow++);
            int k = 0;
            for (Map.Entry<String, Object> entry : list.get(j).entrySet()) {
                HSSFCell cell = rows.createCell(k++);
                cell.setCellValue(entry.getValue() == null ? "" : entry.getValue().toString());
            }
        }
        return workbook;
    }

    public static String returnFirstCapital(String str) {
        if (str.charAt(0) >= 'A' && str.charAt(0) <= 'Z') {
            return str;
        }
        char[] ch = str.toCharArray();
        ch[0] = (char)(ch[0] - 32);
        return String.valueOf(ch);
    }

    public static String[] getFiledNames(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    private static String[] getFieldValues(Object o) {
        int i;
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        String[] fieldValues = new String[fieldNames.length];
        for (i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        try {
            for (i = 0; i < fieldNames.length; ++i) {
                String field;
                String fieldName = fieldNames[i];
                fieldValues[i] = field = o.getClass().getMethod("get" + ExportExcel.returnFirstCapital(fieldName), new Class[0]).invoke(o, new Object[0]).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldValues;
    }
}

