/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.alibaba.nacos.api.config.ConfigService;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMachineDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.MilogStreamService;
import org.apache.ozhera.log.manager.service.impl.MilogConfigNacosServiceImpl;
import org.apache.ozhera.log.manager.service.nacos.MultipleNacosConfig;
import org.apache.ozhera.log.manager.service.nacos.impl.SpaceConfigNacosProvider;
import org.apache.ozhera.log.manager.service.nacos.impl.SpaceConfigNacosPublisher;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosProvider;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosPublisher;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.apache.ozhera.log.model.SinkConfig;

@Service
public class MilogStreamServiceImpl
implements MilogStreamService {
    private StreamConfigNacosProvider streamConfigNacosProvider;
    private StreamConfigNacosPublisher streamConfigNacosPublisher;
    private SpaceConfigNacosProvider spaceConfigNacosProvider;
    private SpaceConfigNacosPublisher spaceConfigNacosPublisher;
    @Resource
    private MilogMachineDao milogMachineDao;
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private MilogConfigNacosServiceImpl milogConfigNacosService;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Value(value="$log_type_mq_not_consume")
    private String logTypeMqNotConsume;

    @Override
    public Result<String> configIssueStream(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return Result.failParam((String)"IP cannot be empty");
        }
        this.streamConfigNacosProvider = new StreamConfigNacosProvider();
        this.spaceConfigNacosProvider = new SpaceConfigNacosProvider();
        this.spaceConfigNacosPublisher = new SpaceConfigNacosPublisher();
        for (String address : MultipleNacosConfig.getAllNachosAdders()) {
            ConfigService configService = MultipleNacosConfig.getConfigService(address);
            this.streamConfigNacosProvider.setConfigService(configService);
            this.spaceConfigNacosProvider.setConfigService(configService);
            this.spaceConfigNacosPublisher.setConfigService(configService);
            MilogMiddlewareConfig milogMiddlewareConfig = this.milogMiddlewareConfigDao.queryNacosRegionByNameServer(address.trim());
            if (null == milogMiddlewareConfig) continue;
            MiLogStreamConfig existConfig = this.streamConfigNacosProvider.getConfig(null);
            Optional.ofNullable(existConfig).map(miLogStreamConfig -> {
                Map config = existConfig.getConfig();
                config.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(ip)).forEach(entry -> {
                    Map streamMap = (Map)entry.getValue();
                    streamMap.keySet().stream().forEach(spaceKey -> {
                        MilogSpaceData milogSpaceData = this.spaceConfigNacosProvider.getConfig((Long)spaceKey);
                        if (null == milogSpaceData) {
                            milogSpaceData = new MilogSpaceData();
                        }
                        List<SinkConfig> sinkConfigs = this.generateSinkConfig((Long)spaceKey, milogMiddlewareConfig.getRegionEn());
                        milogSpaceData.setSpaceConfig(sinkConfigs);
                        this.spaceConfigNacosPublisher.publish((Long)spaceKey, milogSpaceData);
                    });
                });
                return null;
            }).orElse(false);
        }
        return Result.success((Object)"success");
    }

    private List<SinkConfig> generateSinkConfig(Long spaceKey, String region) {
        ArrayList sinkConfigs = Lists.newArrayList();
        List<MilogLogStoreDO> logstoreDOS = this.milogLogstoreDao.getMilogLogstoreBySpaceIdRegion(spaceKey, region.trim());
        logstoreDOS = logstoreDOS.stream().filter(milogLogstoreDO -> !milogLogstoreDO.getLogType().toString().equals(this.logTypeMqNotConsume)).collect(Collectors.toList());
        logstoreDOS.forEach(milogLogstoreDO -> {
            ArrayList sameStoreSinkConfigs = Lists.newArrayList();
            ArrayList logtailConfigs = Lists.newArrayList();
            List<MilogLogTailDo> logtailDos = this.milogLogtailDao.getMilogLogtailByStoreId(milogLogstoreDO.getId());
            for (MilogLogTailDo logtailDo : logtailDos) {
                SinkConfig sinkConfig2 = this.milogConfigNacosService.assembleSinkConfig(milogLogstoreDO.getId(), logtailDo.getId(), MachineRegionEnum.CN_MACHINE.getEn());
                sameStoreSinkConfigs.add(sinkConfig2);
            }
            sameStoreSinkConfigs.stream().forEach(sinkConfig -> logtailConfigs.addAll(sinkConfig.getLogtailConfigs()));
            if (CollectionUtils.isNotEmpty((Collection)sameStoreSinkConfigs)) {
                SinkConfig sameStoresinkConfig = (SinkConfig)sameStoreSinkConfigs.get(0);
                sameStoresinkConfig.setLogtailConfigs((List)logtailConfigs);
                sinkConfigs.add(sameStoresinkConfig);
            }
        });
        return sinkConfigs;
    }

    @Override
    public void executeSql(String sql) {
        this.milogMachineDao.executeSql(sql);
    }
}

