/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.enums.FavouriteSearchEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.mapper.MilogLogSearchSaveMapper;
import org.apache.ozhera.log.manager.model.convert.SearchSaveConvert;
import org.apache.ozhera.log.manager.model.dto.SearchSaveDTO;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.pojo.MilogLogSearchSaveDO;
import org.apache.ozhera.log.manager.model.vo.SearchSaveInsertCmd;
import org.apache.ozhera.log.manager.model.vo.SearchSaveUpdateCmd;
import org.apache.ozhera.log.manager.service.LogSearchSaveService;

@Service
public class LogSearchSaveServiceImpl
implements LogSearchSaveService {
    @Resource
    private MilogLogSearchSaveMapper logSearchSaveMapper;

    public Result<PageInfo<SearchSaveDTO>> list(Long storeId, Integer pageNum, Integer pageSize) {
        Long count = this.logSearchSaveMapper.countByStoreId(storeId);
        List<MilogLogSearchSaveDO> list = this.logSearchSaveMapper.selectByStoreId(storeId, pageSize * (pageNum - 1), pageSize);
        List<SearchSaveDTO> searchSaveDTOList = SearchSaveConvert.INSTANCE.fromDOList(list);
        PageInfo<SearchSaveDTO> res = new PageInfo<SearchSaveDTO>(pageNum, pageSize, count.intValue(), searchSaveDTOList);
        return Result.success(res);
    }

    public SearchSaveDTO getById(Long id) {
        return SearchSaveConvert.INSTANCE.fromDO((MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(id));
    }

    public Result<Integer> save(SearchSaveInsertCmd cmd) {
        if (cmd.getSort() == null) {
            return Result.failParam((String)"The classification field SORT cannot be empty");
        }
        switch (FavouriteSearchEnum.queryByCode((Integer)cmd.getSort())) {
            case TEXT: {
                if (!this.isRepeatName(cmd.getName())) break;
                return Result.failParam((String)"Names cannot be duplicated");
            }
            case STORE: {
                Integer isMyFavouriteStore = this.logSearchSaveMapper.isMyFavouriteStore(MoneUserContext.getCurrentUser().getUser(), cmd.getStoreId());
                if (isMyFavouriteStore >= 1) {
                    return Result.failParam((String)"Bookmarked");
                }
            }
            case TAIL: {
                Integer isMyFavouriteTail = this.logSearchSaveMapper.isMyFavouriteTail(MoneUserContext.getCurrentUser().getUser(), cmd.getTailId());
                if (isMyFavouriteTail < 1) break;
                return Result.failParam((String)"Bookmarked");
            }
        }
        MilogLogSearchSaveDO logSearchSaveDO = SearchSaveConvert.INSTANCE.toDO(cmd);
        long current = System.currentTimeMillis();
        logSearchSaveDO.setCreateTime(current);
        logSearchSaveDO.setUpdateTime(current);
        String user = MoneUserContext.getCurrentUser().getUser();
        logSearchSaveDO.setCreator(user);
        logSearchSaveDO.setUpdater(user);
        Integer maxOrder = this.logSearchSaveMapper.getMaxOrder(user, cmd.getSort());
        logSearchSaveDO.setOrderNum(maxOrder == null ? 100 : maxOrder + 100);
        int insert = this.logSearchSaveMapper.insert(logSearchSaveDO);
        return Result.success((Object)insert);
    }

    public Result<Integer> update(SearchSaveUpdateCmd cmd) {
        MilogLogSearchSaveDO milogLogSearchSaveDO = (MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(cmd.getId());
        if (milogLogSearchSaveDO == null) {
            return Result.failParam((String)"Data not found");
        }
        if (!cmd.getName().equals(milogLogSearchSaveDO.getName()) && this.isRepeatName(cmd.getName())) {
            return Result.failParam((String)"Names cannot be duplicated");
        }
        milogLogSearchSaveDO.setName(cmd.getName());
        milogLogSearchSaveDO.setQueryText(cmd.getQueryText());
        milogLogSearchSaveDO.setIsFixTime(cmd.getIsFixTime());
        milogLogSearchSaveDO.setStartTime(cmd.getStartTime());
        milogLogSearchSaveDO.setEndTime(cmd.getEndTime());
        milogLogSearchSaveDO.setCommon(cmd.getCommon());
        milogLogSearchSaveDO.setUpdateTime(System.currentTimeMillis());
        milogLogSearchSaveDO.setUpdater(MoneUserContext.getCurrentUser().getUser());
        int i = this.logSearchSaveMapper.updateById(milogLogSearchSaveDO);
        return Result.success((Object)i);
    }

    public Result<Integer> removeById(Long id) {
        int i = this.logSearchSaveMapper.removeById(id);
        return Result.success((Object)i);
    }

    private boolean isRepeatName(String name) {
        Long count = this.logSearchSaveMapper.countByStoreAndName(name, MoneUserContext.getCurrentUser().getUser());
        return count >= 1L;
    }
}

