/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.convert;

import java.util.ArrayList;
import java.util.List;
import org.apache.ozhera.log.api.model.vo.AgentLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.TailLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.manager.model.cache.LogCellectProcessCache;
import org.apache.ozhera.log.manager.model.convert.LogProcessConvert;
import org.apache.ozhera.log.manager.model.pojo.MilogLogProcessDO;

public class LogProcessConvertImpl
implements LogProcessConvert {
    @Override
    public AgentLogProcessDTO fromDO(MilogLogProcessDO milogLogProcessDO) {
        if (milogLogProcessDO == null) {
            return null;
        }
        AgentLogProcessDTO agentLogProcessDTO = new AgentLogProcessDTO();
        if (milogLogProcessDO.getFileRowNumber() != null) {
            agentLogProcessDTO.setFileRowNumber(Long.valueOf(milogLogProcessDO.getFileRowNumber().longValue()));
        }
        agentLogProcessDTO.setPointer(milogLogProcessDO.getPointer());
        agentLogProcessDTO.setCollectTime(milogLogProcessDO.getCollectTime());
        return agentLogProcessDTO;
    }

    @Override
    public AgentLogProcessDTO collectProcessToDTO(UpdateLogProcessCmd.CollectDetail collectDetail) {
        if (collectDetail == null) {
            return null;
        }
        AgentLogProcessDTO agentLogProcessDTO = new AgentLogProcessDTO();
        agentLogProcessDTO.setPath(collectDetail.getPath());
        agentLogProcessDTO.setAppName(collectDetail.getAppName());
        return agentLogProcessDTO;
    }

    @Override
    public List<AgentLogProcessDTO> collectProcessToDTOList(List<UpdateLogProcessCmd.CollectDetail> collectDetailList) {
        if (collectDetailList == null) {
            return null;
        }
        ArrayList<AgentLogProcessDTO> list = new ArrayList<AgentLogProcessDTO>(collectDetailList.size());
        for (UpdateLogProcessCmd.CollectDetail collectDetail : collectDetailList) {
            list.add(this.collectProcessToDTO(collectDetail));
        }
        return list;
    }

    @Override
    public LogCellectProcessCache cmdToCache(UpdateLogProcessCmd.CollectDetail collectDetail) {
        if (collectDetail == null) {
            return null;
        }
        LogCellectProcessCache logCellectProcessCache = new LogCellectProcessCache();
        logCellectProcessCache.setTailId(collectDetail.getTailId());
        logCellectProcessCache.setTailName(collectDetail.getTailName());
        logCellectProcessCache.setPath(collectDetail.getPath());
        logCellectProcessCache.setAppId(collectDetail.getAppId());
        logCellectProcessCache.setAppName(collectDetail.getAppName());
        return logCellectProcessCache;
    }

    @Override
    public List<LogCellectProcessCache> cmdToCacheList(List<UpdateLogProcessCmd.CollectDetail> collectDetailList) {
        if (collectDetailList == null) {
            return null;
        }
        ArrayList<LogCellectProcessCache> list = new ArrayList<LogCellectProcessCache>(collectDetailList.size());
        for (UpdateLogProcessCmd.CollectDetail collectDetail : collectDetailList) {
            list.add(this.cmdToCache(collectDetail));
        }
        return list;
    }

    @Override
    public AgentLogProcessDTO cacheToAgentDTO(LogCellectProcessCache cache) {
        if (cache == null) {
            return null;
        }
        AgentLogProcessDTO agentLogProcessDTO = new AgentLogProcessDTO();
        agentLogProcessDTO.setPath(cache.getPath());
        agentLogProcessDTO.setFileRowNumber(cache.getFileRowNumber());
        agentLogProcessDTO.setPointer(cache.getPointer());
        agentLogProcessDTO.setFileMaxPointer(cache.getFileMaxPointer());
        agentLogProcessDTO.setAppName(cache.getAppName());
        agentLogProcessDTO.setCollectPercentage(cache.getCollectPercentage());
        agentLogProcessDTO.setCollectTime(cache.getCollectTime());
        return agentLogProcessDTO;
    }

    @Override
    public List<AgentLogProcessDTO> cacheToAgentDTOList(List<LogCellectProcessCache> cacheList) {
        if (cacheList == null) {
            return null;
        }
        ArrayList<AgentLogProcessDTO> list = new ArrayList<AgentLogProcessDTO>(cacheList.size());
        for (LogCellectProcessCache logCellectProcessCache : cacheList) {
            list.add(this.cacheToAgentDTO(logCellectProcessCache));
        }
        return list;
    }

    @Override
    public TailLogProcessDTO cacheToTailDTO(LogCellectProcessCache cache, String ip, String tailName) {
        if (cache == null && ip == null && tailName == null) {
            return null;
        }
        TailLogProcessDTO.TailLogProcessDTOBuilder tailLogProcessDTO = TailLogProcessDTO.builder();
        if (cache != null) {
            tailLogProcessDTO.path(cache.getPath());
            tailLogProcessDTO.fileRowNumber(cache.getFileRowNumber());
            tailLogProcessDTO.collectTime(cache.getCollectTime());
            tailLogProcessDTO.collectPercentage(cache.getCollectPercentage());
        }
        if (ip != null) {
            tailLogProcessDTO.ip(ip);
        }
        if (tailName != null) {
            tailLogProcessDTO.tailName(tailName);
        }
        return tailLogProcessDTO.build();
    }
}

