/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.RateLimiter;
import com.xiaomi.youpin.docean.Ioc;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.LogSendFilter;
import org.apache.ozhera.log.stream.job.SinkJobConfig;
import org.apache.ozhera.log.stream.job.extension.DefaultLogSendFilter;
import org.apache.ozhera.log.stream.job.extension.MessageLifecycleManager;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MqMessagePostProcessing;
import org.apache.ozhera.log.stream.sink.SinkChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDataTransfer {
    private static final Logger log = LoggerFactory.getLogger(LogDataTransfer.class);
    private final SinkChain sinkChain;
    private final LogParser logParser;
    private final MessageSender messageSender;
    private SinkJobConfig sinkJobConfig;
    private SinkJobEnum jobType;
    private final AtomicLong sendMsgNumber = new AtomicLong(0L);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private RateLimiter rateLimiter = RateLimiter.create((double)1.8E8);
    private MqMessagePostProcessing messagePostProcessing;
    private LogSendFilter logSendFilter;
    private MessageLifecycleManager messageLifecycleManager;

    public LogDataTransfer(SinkChain sinkChain, LogParser logParser, MessageSender messageSender, SinkJobConfig sinkJobConfig) {
        this.sinkChain = sinkChain;
        this.logParser = logParser;
        this.messageSender = messageSender;
        this.sinkJobConfig = sinkJobConfig;
        String mqPostProcessingBean = sinkJobConfig.getMqType() + "postProcessing";
        this.messagePostProcessing = (MqMessagePostProcessing)Ioc.ins().getBean(mqPostProcessingBean);
        this.logSendFilter = (LogSendFilter)Ioc.ins().getBean(DefaultLogSendFilter.class);
        this.messageLifecycleManager = this.getMessageLifecycleManager();
    }

    private MessageLifecycleManager getMessageLifecycleManager() {
        String factualServiceName = Config.ins().get("message.lifecycle.manager", "defaultMessageLifecycleManager");
        return (MessageLifecycleManager)Ioc.ins().getBean(factualServiceName);
    }

    public void handleMessage(String type, String msg, String time) {
        try {
            LineMessage lineMessage = this.parseLineMessage(msg);
            this.messageLifecycleManager.beforeProcess(this.sinkJobConfig, lineMessage);
            Map<String, Object> dataMap = this.parseMessage(lineMessage);
            this.messageLifecycleManager.afterProcess(this.sinkJobConfig, lineMessage, dataMap);
            this.toSendMessage(dataMap);
            this.messagePostProcessing.postProcessing(this.sinkJobConfig, msg);
        }
        catch (Exception e) {
            log.error(this.jobType.name() + " parse and send error", (Throwable)e);
            throw new RuntimeException(String.format("handleMessage error,msg:%s", msg), e);
        }
    }

    private void toSendMessage(Map<String, Object> dataMap) throws Exception {
        if (this.sendMsgNumber.get() % (long)Constant.COUNT_NUM.intValue() == 0L || this.sendMsgNumber.get() == 1L) {
            log.info(this.jobType.name() + " send msg:{}", dataMap);
        }
        if (SinkJobEnum.NORMAL_JOB == this.jobType) {
            if (null != dataMap && !this.sinkChain.execute(dataMap)) {
                this.sendMessage(dataMap);
            }
        } else {
            this.sendMessage(dataMap);
        }
    }

    private Map<String, Object> parseMessage(LineMessage lineMessage) {
        String ip = lineMessage.getProperties(LineMessage.KEY_IP);
        Long lineNumber = lineMessage.getLineNumber();
        Map dataMap = this.logParser.parse(lineMessage.getMsgBody(), ip, lineNumber, Long.valueOf(lineMessage.getTimestamp()), lineMessage.getFileName());
        this.putCommonData(dataMap);
        return dataMap;
    }

    private LineMessage parseLineMessage(String msg) throws JsonProcessingException {
        return (LineMessage)this.objectMapper.readValue(msg, LineMessage.class);
    }

    private void putCommonData(Map<String, Object> dataMap) {
        dataMap.putIfAbsent("spaceId", this.sinkJobConfig.getLogSpaceId());
        dataMap.putIfAbsent("storeId", this.sinkJobConfig.getLogStoreId());
        dataMap.putIfAbsent("tailId", this.sinkJobConfig.getLogTailId());
    }

    private void sendMessage(Map<String, Object> dataMap) throws Exception {
        if (!this.logSendFilter.sendMessageSwitch(dataMap)) {
            return;
        }
        this.doSendMessage(dataMap);
    }

    private void doSendMessage(Map<String, Object> m) throws Exception {
        this.sendMsgNumber.incrementAndGet();
        this.rateLimiter.acquire();
        this.checkInsertTimeStamp(m);
        this.messageSender.send(m);
    }

    public void checkInsertTimeStamp(Map<String, Object> mapData) {
        mapData.putIfAbsent("timestamp", Instant.now().toEpochMilli());
        Object timeStamp = mapData.get("timestamp");
        if (timeStamp.toString().length() != LogParser.TIME_STAMP_MILLI_LENGTH.intValue()) {
            mapData.put("timestamp", Instant.now().toEpochMilli());
        }
    }

    public SinkJobConfig getSinkJobConfig() {
        return this.sinkJobConfig;
    }

    public void setSinkJobConfig(SinkJobConfig sinkJobConfig) {
        this.sinkJobConfig = sinkJobConfig;
    }

    public void setJobType(SinkJobEnum jobType) {
        this.jobType = jobType;
    }
}

