/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderDateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplZonedDateTime;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.function.BiConsumer;

public class FieldReaderZonedDateTime<T>
extends FieldReaderDateTimeCodec<T> {
    final BiConsumer<T, ZonedDateTime> function;

    FieldReaderZonedDateTime(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Field field, Method method, BiConsumer<T, ZonedDateTime> function) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field);
        this.function = function;
    }

    @Override
    protected void accept(T object, Date value) {
        Instant instant = value.toInstant();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
        this.accept(object, zdt);
    }

    @Override
    protected void accept(T object, Instant instant) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
        this.accept(object, zdt);
    }

    @Override
    protected void accept(T object, LocalDateTime ldt) {
        ZonedDateTime zdt = ZonedDateTime.of(ldt, DateUtils.DEFAULT_ZONE_ID);
        this.accept(object, zdt);
    }

    @Override
    protected Object apply(Date value) {
        Instant instant = value.toInstant();
        return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
    }

    @Override
    protected Object apply(Instant value) {
        return ZonedDateTime.ofInstant(value, DateUtils.DEFAULT_ZONE_ID);
    }

    @Override
    protected Object apply(ZonedDateTime zdt) {
        return zdt;
    }

    @Override
    protected Object apply(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
    }

    @Override
    protected Object apply(LocalDateTime ldt) {
        return ldt.atZone(DateUtils.DEFAULT_ZONE_ID);
    }

    @Override
    protected void acceptNull(T object) {
        this.accept(object, (ZonedDateTime)null);
    }

    @Override
    public void accept(T object, long milli) {
        Instant instant = Instant.ofEpochMilli(milli);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
        this.accept(object, zdt);
    }

    @Override
    protected void accept(T object, ZonedDateTime zdt) {
        if (this.schema != null) {
            this.schema.assertValidate(zdt);
        }
        if (zdt == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        if (object == null) {
            throw new JSONException("set " + this.fieldName + " error, object is null");
        }
        if (this.function != null) {
            this.function.accept(object, zdt);
            return;
        }
        if (this.method != null) {
            try {
                this.method.invoke(object, zdt);
            }
            catch (Exception e) {
                throw new JSONException("set " + this.fieldName + " error", e);
            }
            return;
        }
        if (this.fieldOffset != -1L) {
            UnsafeUtils.putObject(object, this.fieldOffset, zdt);
            return;
        }
        try {
            this.field.set(object, zdt);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplZonedDateTime.INSTANCE : new ObjectReaderImplZonedDateTime(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplZonedDateTime.INSTANCE : new ObjectReaderImplZonedDateTime(this.format, this.locale);
        }
        return this.dateReader;
    }
}

