/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.filter.DoceanFilter;
import com.xiaomi.mone.tpc.login.util.CommonUtil;
import com.xiaomi.mone.tpc.login.util.SignUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.UserInfoVO;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanAuthCasFilter
extends DoceanFilter {
    private static final Logger log = LoggerFactory.getLogger(DoceanAuthCasFilter.class);
    private String[] publicKeys = null;
    private String[] ignoreUrls;

    @Override
    public void init(Map<String, String> filterConfig) {
        String publicKeyStr = filterConfig.get("AEGIS_SDK_PUBLIC_KEY");
        if (StringUtils.isBlank((CharSequence)publicKeyStr)) {
            throw new IllegalArgumentException("CAS_PUBLIC_KEY must config");
        }
        this.publicKeys = publicKeyStr.split("[,|\uff0c]");
        String ignoreUrl = filterConfig.get("IGNORE_URL");
        if (StringUtils.isNotBlank((CharSequence)ignoreUrl)) {
            this.ignoreUrls = ignoreUrl.split("[,|\uff0c]");
            log.info("\u5df2\u8bbe\u7f6e\u5ffd\u7565\u8def\u5f84\uff0cignoreUrls:{}", (Object)ignoreUrl);
        }
    }

    @Override
    public boolean doFilter(MvcContext mvcContext) {
        try {
            String url = mvcContext.getPath();
            log.info("AuthCasFilter begin filter url:{}", (Object)url);
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, url)) {
                log.info("\u914d\u7f6e\u4e3a\u5ffd\u7565\u7684\u8def\u5f84,url:{}", (Object)url);
                return true;
            }
            String verifyIdentitySignData = (String)mvcContext.getHeaders().get("X-Proxy-Midun");
            if (StringUtils.isEmpty((CharSequence)verifyIdentitySignData)) {
                log.error("\u6ca1\u6709\u6807\u8bc6\u8eab\u4efd\u7684\u7b7e\u540d\u6570\u636e,url:{}", (Object)url);
                this.noAuthResponse(mvcContext);
                return false;
            }
            String currentUsePublicKey = null;
            String verifyIdentityData = null;
            for (String key : this.publicKeys) {
                verifyIdentityData = SignUtil.verifySignGetInfo(verifyIdentitySignData, key);
                if (!StringUtils.isNotEmpty((CharSequence)verifyIdentityData)) continue;
                currentUsePublicKey = key;
                break;
            }
            if (StringUtils.isEmpty(verifyIdentityData)) {
                log.error("\u68c0\u6d4b\u8eab\u4efd,\u9a8c\u7b7e\u5931\u8d25,url:{},signData:{}", (Object)url, (Object)verifyIdentitySignData);
                this.noAuthResponse(mvcContext);
                return false;
            }
            log.info("\u8d26\u53f7\u767b\u5f55,url:{}", (Object)url);
            String signAndUserSignData = (String)mvcContext.getHeaders().get("x-proxy-userdetail");
            if (StringUtils.isEmpty((CharSequence)signAndUserSignData)) {
                log.info("\u786e\u8ba4\u8bf7\u6c42\uff0c\u6ca1\u6709\u7b7e\u540d\u7528\u6237\u6570\u636e(bypass|\u9759\u6001\u8d44\u6e90)\uff0curl:{}", (Object)url);
                return true;
            }
            String userJson = SignUtil.verifySignGetInfo(signAndUserSignData, currentUsePublicKey);
            if (StringUtils.isEmpty((CharSequence)userJson)) {
                log.error("\u83b7\u53d6\u7528\u6237\u6570\u636e\uff0c\u9a8c\u7b7e\u5931\u8d25,url:{},signData:{}", (Object)url, (Object)signAndUserSignData);
                this.noAuthResponse(mvcContext);
                return false;
            }
            Gson gson = new GsonBuilder().serializeNulls().create();
            UserInfoVO userInfo = (UserInfoVO)gson.fromJson(userJson, UserInfoVO.class);
            AuthUserVo authUserVo = new AuthUserVo();
            authUserVo.setUserType(UserTypeEnum.CAS_TYPE.getCode());
            authUserVo.setAccount(userInfo.getUser());
            authUserVo.setName(userInfo.getDisplayName());
            authUserVo.setEmail(userInfo.getEmail());
            authUserVo.setAvatarUrl(userInfo.getAvatar());
            authUserVo.setCasUid(userInfo.getuID());
            authUserVo.setDepartmentName(userInfo.getDepartmentName());
            mvcContext.session().setAttribute("TPC_USER", (Object)authUserVo);
            return true;
        }
        catch (Throwable e) {
            log.error("AuthCasFilter check exception", e);
            throw new RuntimeException(e);
        }
    }

    private void noAuthResponse(MvcContext mvcContext) {
        mvcContext.getResHeaders().put("x-status", "401");
    }

    @Override
    public void destroy() {
        log.info("AuthCasFilter destroy finish..");
    }
}

