/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.result;

import java.io.Serializable;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;

public class Result<T>
implements Serializable {
    private int code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public boolean isSuccess() {
        return ErrorCode.success.getCode() == this.code;
    }

    public static <T> Result<T> fail(ErrorCode error) {
        return new Result<T>(error.getCode(), error.getMessage());
    }

    public static <T> Result<T> fail(ErrorCode error, T t) {
        return new Result<T>(error.getCode(), error.getMessage(), t);
    }

    public static <T> Result<T> success(T t) {
        return new Result<T>(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), t);
    }

    public static <T> Result<T> success() {
        return new Result<Object>(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), null);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }
}

