/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateInfo;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateParam;
import org.apache.ozhera.monitor.dao.RulePromQLTemplateDao;
import org.apache.ozhera.monitor.dao.model.RulePromQLTemplate;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.RulePromQLTemplateService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RulePromQLTemplateServiceImpl
implements RulePromQLTemplateService {
    private static final Logger log = LoggerFactory.getLogger(RulePromQLTemplateServiceImpl.class);
    @Autowired
    private RulePromQLTemplateDao rulePromQLTemplateDao;
    @NacosValue(value="${prometheus.url}", autoRefreshed=true)
    private String prometheusUrl;
    @NacosValue(value="${prometheus.check.url}", autoRefreshed=true)
    private String prometheusCheckUrl;

    @Override
    public Result add(String user, RulePromQLTemplateParam param) {
        List<RulePromQLTemplate> templates = this.rulePromQLTemplateDao.getByName(user, param.getName());
        if (!CollectionUtils.isEmpty(templates)) {
            Result result = Result.fail((ErrorCode)ErrorCode.invalidParamError);
            result.setMessage("\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d");
            return result;
        }
        RulePromQLTemplate template = new RulePromQLTemplate();
        BeanUtils.copyProperties((Object)param, (Object)template);
        template.setCreater(user);
        if (!this.rulePromQLTemplateDao.insert(template)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("add PromQL template \u6210\u529f\uff1auser={}, template={}", (Object)user, (Object)template);
        return Result.success(null);
    }

    @Override
    public Result edit(String user, RulePromQLTemplateParam param) {
        List<RulePromQLTemplate> templates = this.rulePromQLTemplateDao.getByName(user, param.getName());
        if (templates != null && templates.size() > 1) {
            Result result = Result.fail((ErrorCode)ErrorCode.invalidParamError);
            result.setMessage("\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d");
            return result;
        }
        RulePromQLTemplate template = new RulePromQLTemplate();
        BeanUtils.copyProperties((Object)param, (Object)template);
        template.setCreater(null);
        if (!this.rulePromQLTemplateDao.updateById(template)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("updateById PromQL template \u6210\u529f\uff1auser={}, template={}", (Object)user, (Object)template);
        return Result.success(null);
    }

    @Override
    public Result deleteById(String user, Integer templateId) {
        if (!this.rulePromQLTemplateDao.deleteById(templateId)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("deleteById PromQL template \u6210\u529f\uff1auser={}, templateId={}", (Object)user, (Object)templateId);
        return Result.success(null);
    }

    @Override
    public Result<PageData<List<RulePromQLTemplateInfo>>> search(String user, RulePromQLTemplateParam param) {
        RulePromQLTemplate template = new RulePromQLTemplate();
        PageData<List<RulePromQLTemplateInfo>> pageData = this.rulePromQLTemplateDao.searchByCond(user, param);
        log.info("query promQL template user={}, param={}, pageData={}", new Object[]{user, param, pageData});
        return Result.success(pageData);
    }

    @Override
    public Result<String> testPromQL(String user, RulePromQLTemplateParam param) throws UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        url.append(this.prometheusCheckUrl).append("graph?g0.expr=").append(URLEncoder.encode(param.getPromql(), "UTF-8")).append("&g0.tab=1&g0.stacked=0&g0.range_input=1h");
        return Result.success((Object)url.toString());
    }
}

