/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateInfo;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateParam;
import org.apache.ozhera.monitor.dao.model.RulePromQLTemplate;
import org.apache.ozhera.monitor.service.model.PageData;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RulePromQLTemplateDao {
    private static final Logger log = LoggerFactory.getLogger(RulePromQLTemplateDao.class);
    @Autowired
    private Dao dao;

    public RulePromQLTemplate getById(Integer id) {
        return (RulePromQLTemplate)this.dao.fetch(RulePromQLTemplate.class, (long)id.intValue());
    }

    public boolean insert(RulePromQLTemplate template) {
        if (template.getStatus() == null) {
            template.setStatus(0);
        }
        if (template.getType() == null) {
            template.setType(1);
        }
        if (template.getUpdateTime() == null) {
            template.setUpdateTime(new Date());
        }
        if (template.getCreateTime() == null) {
            template.setCreateTime(new Date());
        }
        try {
            return this.dao.insert((Object)template) != null;
        }
        catch (Exception e) {
            log.error("RulePromQLTemplate\u8868\u63d2\u5165\u5f02\u5e38\uff1b template={}", (Object)template, (Object)e);
            return false;
        }
    }

    public boolean updateById(RulePromQLTemplate template) {
        if (template.getUpdateTime() == null) {
            template.setUpdateTime(new Date());
        }
        try {
            return this.dao.updateIgnoreNull((Object)template) > 0;
        }
        catch (Exception e) {
            log.error("RulePromQLTemplate\u8868\u66f4\u65b0\u5f02\u5e38\uff1b template={}", (Object)template, (Object)e);
            return false;
        }
    }

    public boolean deleteById(Integer id) {
        try {
            return this.dao.delete(RulePromQLTemplate.class, (long)id.intValue()) > 0;
        }
        catch (Exception e) {
            log.error("RulePromQLTemplate\u8868\u5220\u9664\u5f02\u5e38\uff1b id={}", (Object)id, (Object)e);
            return false;
        }
    }

    public PageData<List<RulePromQLTemplateInfo>> searchByCond(String user, RulePromQLTemplateParam param) {
        List list;
        PageData<List<RulePromQLTemplateInfo>> pageData = new PageData<List<RulePromQLTemplateInfo>>();
        pageData.setPage(param.getPage());
        pageData.setPageSize(param.getPageSize());
        pageData.setTotal(0L);
        Cnd cnd = Cnd.where((String)"creater", (String)"=", (Object)user);
        if (StringUtils.isNotBlank((CharSequence)param.getName())) {
            StringBuilder name = new StringBuilder();
            name.append("%").append(param.getName()).append("%");
            cnd = cnd.and("name", "LIKE", (Object)name.toString());
        }
        if (param.isPaging()) {
            int total = this.dao.count(RulePromQLTemplate.class, (Condition)cnd);
            if (total <= 0) {
                return pageData;
            }
            pageData.setTotal(Long.valueOf(total));
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.dao.query(RulePromQLTemplate.class, (Condition)cnd, new Pager(param.getPage(), param.getPageSize()))))) {
            pageData.setList(list.stream().map(temple -> {
                RulePromQLTemplateInfo info = new RulePromQLTemplateInfo();
                BeanUtils.copyProperties((Object)temple, (Object)info);
                if (temple.getCreateTime() != null) {
                    info.setCreateTime(temple.getCreateTime().getTime());
                }
                if (temple.getUpdateTime() != null) {
                    info.setUpdateTime(temple.getUpdateTime().getTime());
                }
                return info;
            }).collect(Collectors.toList()));
        }
        return pageData;
    }

    public List<RulePromQLTemplate> getByName(String user, String name) {
        Cnd cnd = Cnd.where((String)"creater", (String)"=", (Object)user).and("name", "=", (Object)name);
        return this.dao.query(RulePromQLTemplate.class, (Condition)cnd);
    }
}

