/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.bo;

import java.util.ArrayList;
import java.util.List;
import org.apache.ozhera.monitor.bo.Pair;

public enum AppType {
    businessType(0, "businessType"),
    hostType(1, "hostType"),
    serverless(2, "serverless"),
    mesh(3, "businessType");

    private Integer code;
    private String message;

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private AppType(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static AppType getEnum(Integer code) {
        AppType[] values;
        if (code == null) {
            return null;
        }
        for (AppType value : values = AppType.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }

    public static List<Pair> getCodeDescList() {
        AppType[] values;
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (AppType value : values = AppType.values()) {
            Pair<Integer> pair = new Pair<Integer>(value.getCode(), value.getMessage());
            list.add(pair);
        }
        return list;
    }
}

