/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.extension;

import com.google.common.base.Preconditions;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.exception.AgentException;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.agent.extension.RmqExporter;
import org.apache.ozhera.log.agent.extension.RmqOutput;
import org.apache.ozhera.log.agent.output.Output;
import org.apache.ozhera.log.agent.service.OutPutService;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.api.model.meta.MQConfig;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="RocketMQService")
public class RocketMQService
implements OutPutService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQService.class);
    private ConcurrentHashMap<String, DefaultMQProducer> producerMap;

    public void init() {
        this.producerMap = new ConcurrentHashMap(128);
    }

    @Override
    public boolean compare(Output oldOutput, Output newOutput) {
        if (!Objects.equals(oldOutput.getOutputType(), newOutput.getOutputType())) {
            return false;
        }
        if (oldOutput instanceof RmqOutput && newOutput instanceof RmqOutput) {
            RmqOutput oldRmqOutput = (RmqOutput)oldOutput;
            RmqOutput newRmqOutput = (RmqOutput)newOutput;
            return oldRmqOutput.equals(newRmqOutput);
        }
        return false;
    }

    @Override
    public void preCheckOutput(Output output) {
        RmqOutput rmqOutput = (RmqOutput)output;
        Preconditions.checkArgument((null != rmqOutput.getClusterInfo() ? 1 : 0) != 0, (Object)"rmqOutput.getClusterInfo can not be null");
        Preconditions.checkArgument((null != rmqOutput.getTopic() ? 1 : 0) != 0, (Object)"rmqOutput.getTopic can not be null");
        Preconditions.checkArgument((null != rmqOutput.getProducerGroup() ? 1 : 0) != 0, (Object)"rmqOutput.getProducerGroup can not be null");
    }

    @Override
    public MsgExporter exporterTrans(Output output) {
        RmqOutput rmqOutput = (RmqOutput)output;
        String nameSrvAddr = rmqOutput.getClusterInfo();
        DefaultMQProducer mqProducer = this.producerMap.get(nameSrvAddr);
        if (null == mqProducer) {
            mqProducer = this.initMqProducer(rmqOutput);
            this.producerMap.put(String.valueOf(nameSrvAddr), mqProducer);
        }
        RmqExporter rmqExporter = new RmqExporter(mqProducer);
        rmqExporter.setRmqTopic(rmqOutput.getTopic());
        rmqExporter.setBatchSize(rmqOutput.getBatchExportSize());
        return rmqExporter;
    }

    @Override
    public void removeMQ(Output output) {
    }

    @Override
    public Output configOutPut(LogPattern logPattern) {
        MQConfig mqConfig = logPattern.getMQConfig();
        RmqOutput output = new RmqOutput();
        output.setOutputType("rocketmq");
        output.setClusterInfo(mqConfig.getClusterInfo());
        output.setProducerGroup(mqConfig.getProducerGroup());
        output.setAk(mqConfig.getAk());
        output.setSk(mqConfig.getSk());
        output.setTopic(mqConfig.getTopic());
        output.setPartitionCnt(mqConfig.getPartitionCnt());
        output.setTag(mqConfig.getTag());
        output.setProducerGroup("subGroup_" + (null == logPattern.getPatternCode() ? "" : logPattern.getPatternCode()));
        return output;
    }

    private DefaultMQProducer initMqProducer(RmqOutput rmqOutput) {
        DefaultMQProducer producer;
        if (StringUtils.isNotEmpty((CharSequence)rmqOutput.getAk()) && StringUtils.isNotEmpty((CharSequence)rmqOutput.getSk())) {
            AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(rmqOutput.getAk(), rmqOutput.getSk()));
            producer = new DefaultMQProducer(rmqOutput.getProducerGroup() + "x", (RPCHook)rpcHook, true, null);
        } else {
            producer = new DefaultMQProducer(rmqOutput.getProducerGroup() + "x", true);
        }
        producer.setNamesrvAddr(rmqOutput.getClusterInfo());
        try {
            producer.start();
            return producer;
        }
        catch (MQClientException e) {
            log.error("ChannelBootstrap.initMqProducer error, RocketmqConfig: {}", (Object)rmqOutput, (Object)e);
            throw new AgentException("initMqProducer exception", e);
        }
    }
}

