/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.common;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.ozhera.log.agent.input.AppLogInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractElementAdapter
implements JsonSerializer<Object>,
JsonDeserializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractElementAdapter.class);
    private static final String KEY_TYPE = "type";
    private Map<String, String> typeToClassMap = AbstractElementAdapter.loadTypeToClassMappingFromConfig();

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        String implType = jsonObj.get(KEY_TYPE).getAsString();
        Class<?> clz = this.getClassForImplType(implType);
        return jsonDeserializationContext.deserialize(jsonElement, clz);
    }

    private Class<?> getClassForImplType(String implType) throws ClassNotFoundException {
        String className = this.typeToClassMap.get(implType);
        if (className != null && !className.isEmpty()) {
            return Class.forName(className);
        }
        return AppLogInput.class;
    }

    private static Map<String, String> loadTypeToClassMappingFromConfig() {
        HashMap<String, String> typeToClassMap = new HashMap<String, String>();
        String configFile = "log_impl_type.json";
        try (InputStream input = AbstractElementAdapter.class.getClassLoader().getResourceAsStream(configFile);){
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)).getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                typeToClassMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        catch (Exception e) {
            log.error("loadTypeToClassMappingFromConfig error,fileName:{}", (Object)configFile, (Object)e);
        }
        return typeToClassMap;
    }

    public JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonElement jsonEle = jsonSerializationContext.serialize(object, object.getClass());
        return jsonEle;
    }
}

