/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.bootstrap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.bo.ClientInfo;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.task.Task;
import com.xiaomi.youpin.docean.Aop;
import com.xiaomi.youpin.docean.Ioc;
import java.io.IOException;
import java.util.List;
import org.apache.ozhera.log.agent.common.Version;
import org.apache.ozhera.log.agent.rpc.task.PingTask;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.utils.ConfigUtils;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiLogAgentBootstrap {
    private static final Logger log = LoggerFactory.getLogger(MiLogAgentBootstrap.class);

    public static void main(String[] args) throws IOException {
        String nacosAddr = ConfigUtils.getConfigValue((String)"nacosAddr");
        String serviceName = ConfigUtils.getConfigValue((String)"serviceName");
        log.info("nacosAddr:{},serviceName:{},version:{}", new Object[]{nacosAddr, serviceName, new Version()});
        String appName = Config.ins().get("app_name", "milog_agent");
        ClientInfo clientInfo = new ClientInfo(String.format("%s_%d", appName, ConfigUtils.getDataHashKey((String)NetUtil.getLocalIp(), (int)Integer.parseInt(Config.ins().get("app_max_index", "30")))), NetUtil.getLocalIp(), Integer.parseInt(Config.ins().get("port", "9799")), String.valueOf(new Version()) + ":" + serviceName + ":" + nacosAddr);
        RpcClient client = new RpcClient(nacosAddr, serviceName);
        client.setClearServerAddr(false);
        client.setReconnection(false);
        client.setClientInfo(clientInfo);
        client.start();
        client.setTasks((List)Lists.newArrayList((Object[])new Task[]{new PingTask(client)}));
        client.init();
        client.waitStarted();
        log.info("create rpc client finish");
        Aop.ins().init(Maps.newLinkedHashMap());
        Ioc.ins().putBean((Object)client).init(new String[]{"org.apache.ozhera.log.agent", "com.xiaomi.youpin.docean"});
        client.registerProcessor();
        System.in.read();
    }
}

