/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.spi.CopyOnWrite;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertyKey;

public class ContextDataInjectorFactory {
    public static ContextDataInjector createInjector() {
        try {
            return (ContextDataInjector)LoaderUtil.newCheckedInstanceOfProperty((PropertyKey)Log4jPropertyKey.THREAD_CONTEXT_DATA_INJECTOR_CLASS_NAME, ContextDataInjector.class, ContextDataInjectorFactory::createDefaultInjector);
        }
        catch (ReflectiveOperationException e) {
            StatusLogger.getLogger().warn("Could not create ContextDataInjector: {}", (Object)e.getMessage(), (Object)e);
            return ContextDataInjectorFactory.createDefaultInjector();
        }
    }

    private static ContextDataInjector createDefaultInjector() {
        ReadOnlyThreadContextMap threadContextMap = ThreadContext.getThreadContextMap();
        if (threadContextMap == null) {
            return new ThreadContextDataInjector.ForDefaultThreadContextMap();
        }
        if (threadContextMap instanceof CopyOnWrite) {
            return new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap();
        }
        return new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
    }
}

