/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder;

import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.geo.Line;
import org.apache.lucene.index.IndexableField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRowMapper
implements Function<DataRow, Document> {
    private static final Logger logger = LoggerFactory.getLogger(DataRowMapper.class);

    @Override
    public Document apply(DataRow dataRow) {
        Document doc = new Document();
        DataSchema schema = dataRow.schema();
        List columns = schema.columns();
        for (int i = 0; i < columns.size(); ++i) {
            Object value = dataRow.get(i);
            if (value == null) continue;
            DataColumn column = (DataColumn)columns.get(i);
            this.applyValue(column, doc, value);
        }
        return doc;
    }

    private void applyValue(DataColumn column, Document doc, Object value) {
        String columnName = column.name();
        DataColumn.Type type = column.type();
        try {
            switch (type) {
                case BINARY: {
                    doc.add((IndexableField)new StoredField(columnName, (byte[])value));
                    break;
                }
                case BYTE: {
                    doc.add((IndexableField)new IntPoint(columnName, new int[]{((Byte)value).intValue()}));
                    doc.add((IndexableField)new StoredField(columnName, ((Byte)value).intValue()));
                    break;
                }
                case BOOLEAN: {
                    doc.add((IndexableField)new StringField(columnName, value.toString(), Field.Store.YES));
                    break;
                }
                case SHORT: {
                    doc.add((IndexableField)new IntPoint(columnName, new int[]{((Short)value).intValue()}));
                    doc.add((IndexableField)new StoredField(columnName, ((Short)value).intValue()));
                    break;
                }
                case INTEGER: {
                    doc.add((IndexableField)new IntPoint(columnName, new int[]{(Integer)value}));
                    doc.add((IndexableField)new StoredField(columnName, ((Integer)value).intValue()));
                    break;
                }
                case LONG: {
                    doc.add((IndexableField)new LongPoint(columnName, new long[]{(Long)value}));
                    doc.add((IndexableField)new StoredField(columnName, ((Long)value).longValue()));
                    break;
                }
                case FLOAT: {
                    doc.add((IndexableField)new FloatPoint(columnName, new float[]{((Float)value).floatValue()}));
                    doc.add((IndexableField)new StoredField(columnName, ((Float)value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    doc.add((IndexableField)new DoublePoint(columnName, new double[]{(Double)value}));
                    doc.add((IndexableField)new StoredField(columnName, ((Double)value).doubleValue()));
                    break;
                }
                case STRING: {
                    doc.add((IndexableField)new TextField(columnName, (String)value, Field.Store.YES));
                    break;
                }
                case COORDINATE: {
                    Coordinate coord = (Coordinate)value;
                    double lat = coord.getY();
                    double lon = coord.getX();
                    doc.add((IndexableField)new LatLonPoint(columnName, lat, lon));
                    doc.add((IndexableField)new StoredField(columnName + "_lat", lat));
                    doc.add((IndexableField)new StoredField(columnName + "_lon", lon));
                    break;
                }
                case POINT: {
                    Point point = (Point)value;
                    double pointLat = point.getY();
                    double pointLon = point.getX();
                    doc.add((IndexableField)new LatLonPoint(columnName, pointLat, pointLon));
                    doc.add((IndexableField)new StoredField(columnName + "_lat", pointLat));
                    doc.add((IndexableField)new StoredField(columnName + "_lon", pointLon));
                    break;
                }
                case LINESTRING: 
                case POLYGON: 
                case MULTIPOINT: 
                case MULTILINESTRING: 
                case MULTIPOLYGON: 
                case GEOMETRYCOLLECTION: 
                case GEOMETRY: {
                    Geometry geometry = (Geometry)value;
                    if (geometry != null) {
                        Field[] shapeFields;
                        for (Field field : shapeFields = this.createShapeFields(columnName, geometry)) {
                            doc.add((IndexableField)field);
                        }
                        doc.add((IndexableField)new StoredField(columnName + "_wkt", geometry.toText()));
                    }
                    break;
                }
                case ENVELOPE: {
                    Envelope envelope = (Envelope)value;
                    String envelopeStr = envelope.toString();
                    doc.add((IndexableField)new StringField(columnName, envelopeStr, Field.Store.YES));
                    break;
                }
                case INET_ADDRESS: 
                case INET4_ADDRESS: 
                case INET6_ADDRESS: {
                    InetAddress addr = (InetAddress)value;
                    doc.add((IndexableField)new StringField(columnName, addr.getHostAddress(), Field.Store.YES));
                    break;
                }
                case LOCAL_DATE: {
                    LocalDate date = (LocalDate)value;
                    doc.add((IndexableField)new StringField(columnName, date.toString(), Field.Store.YES));
                    break;
                }
                case LOCAL_TIME: {
                    LocalTime time = (LocalTime)value;
                    doc.add((IndexableField)new StringField(columnName, time.toString(), Field.Store.YES));
                    break;
                }
                case LOCAL_DATE_TIME: {
                    LocalDateTime dateTime = (LocalDateTime)value;
                    doc.add((IndexableField)new StringField(columnName, dateTime.toString(), Field.Store.YES));
                    break;
                }
                case NESTED: {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        String nestedKey = columnName + "." + (String)entry.getKey();
                        Object nestedValue = entry.getValue();
                        if (nestedValue == null) continue;
                        doc.add((IndexableField)new TextField(nestedKey, nestedValue.toString(), Field.Store.YES));
                    }
                    break;
                }
                default: {
                    doc.add((IndexableField)new StringField(columnName, value.toString(), Field.Store.YES));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error processing column '{}' with value '{}': {}", new Object[]{columnName, value, e.getMessage()});
        }
    }

    private Field[] createShapeFields(String fieldName, Geometry geometry) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            double lat = point.getY();
            double lon = point.getX();
            return new Field[]{new LatLonPoint(fieldName, lat, lon)};
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return LatLonShape.createIndexableFields((String)fieldName, (Line)this.convertToLuceneLine(lineString));
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            org.apache.lucene.geo.Polygon lucenePolygon = this.convertToLucenePolygon(polygon);
            return LatLonShape.createIndexableFields((String)fieldName, (org.apache.lucene.geo.Polygon)lucenePolygon);
        }
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            return this.createFieldsFromMultiPolygon(fieldName, multiPolygon);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                Geometry geom = collection.getGeometryN(i);
                Field[] fields = this.createShapeFields(fieldName, geom);
                fieldList.addAll(Arrays.asList(fields));
            }
            return fieldList.toArray(new Field[0]);
        }
        logger.warn("Unsupported geometry type '{}' for field '{}'", (Object)geometry.getGeometryType(), (Object)fieldName);
        return new Field[0];
    }

    private Line convertToLuceneLine(LineString lineString) {
        Coordinate[] coords = lineString.getCoordinates();
        double[] lats = new double[coords.length];
        double[] lons = new double[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            lats[i] = coords[i].getY();
            lons[i] = coords[i].getX();
        }
        return new Line(lats, lons);
    }

    private org.apache.lucene.geo.Polygon convertToLucenePolygon(Polygon jtsPolygon) {
        LinearRing shell = jtsPolygon.getExteriorRing();
        Coordinate[] shellCoords = shell.getCoordinates();
        double[] lats = new double[shellCoords.length];
        double[] lons = new double[shellCoords.length];
        for (int i = 0; i < shellCoords.length; ++i) {
            lats[i] = shellCoords[i].getY();
            lons[i] = shellCoords[i].getX();
        }
        int numHoles = jtsPolygon.getNumInteriorRing();
        org.apache.lucene.geo.Polygon[] holes = new org.apache.lucene.geo.Polygon[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            LinearRing hole = jtsPolygon.getInteriorRingN(i);
            Coordinate[] holeCoords = hole.getCoordinates();
            double[] holeLats = new double[holeCoords.length];
            double[] holeLons = new double[holeCoords.length];
            for (int j = 0; j < holeCoords.length; ++j) {
                holeLats[j] = holeCoords[j].getY();
                holeLons[j] = holeCoords[j].getX();
            }
            holes[i] = new org.apache.lucene.geo.Polygon(holeLats, holeLons, new org.apache.lucene.geo.Polygon[0]);
        }
        return new org.apache.lucene.geo.Polygon(lats, lons, holes);
    }

    private Field[] createFieldsFromMultiPolygon(String fieldName, MultiPolygon multiPolygon) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
            org.apache.lucene.geo.Polygon lucenePolygon = this.convertToLucenePolygon(polygon);
            Field[] fields = LatLonShape.createIndexableFields((String)fieldName, (org.apache.lucene.geo.Polygon)lucenePolygon);
            fieldList.addAll(Arrays.asList(fields));
        }
        return fieldList.toArray(new Field[0]);
    }
}

